/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeployHandlerLogger
implements DeployLogger {
    private static final Logger log = Logger.getLogger(DeployHandlerLogger.class.getName());
    private final String prefix;
    private final boolean verbose;
    private final Slime slime;
    private final Cursor logroot;

    private DeployHandlerLogger(String prefix, boolean verbose) {
        this.prefix = prefix;
        this.verbose = verbose;
        this.slime = new Slime();
        this.logroot = this.slime.setObject().setArray("log");
    }

    public void log(Level level, String message) {
        if (!(level != Level.FINE && level != LogLevel.DEBUG && level != LogLevel.SPAM || this.verbose)) {
            return;
        }
        String fullMsg = this.prefix + message;
        Cursor entry = this.logroot.addObject();
        entry.setLong("time", System.currentTimeMillis());
        entry.setString("level", level.getName());
        entry.setString("message", fullMsg);
        log.log(Level.FINE, fullMsg);
    }

    public Slime slime() {
        return this.slime;
    }

    public static DeployHandlerLogger forApplication(ApplicationId app, boolean verbose) {
        return new DeployHandlerLogger(TenantRepository.logPre(app), verbose);
    }

    public static DeployHandlerLogger forTenant(TenantName tenantName, boolean verbose) {
        return new DeployHandlerLogger(TenantRepository.logPre(tenantName), verbose);
    }

    public static DeployHandlerLogger forPrepareParams(PrepareParams prepareParams) {
        return DeployHandlerLogger.forApplication(prepareParams.getApplicationId(), prepareParams.isVerbose());
    }
}

