/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.slime.Cursor;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.application.ApplicationReindexing;
import com.yahoo.vespa.config.server.application.ClusterReindexing;
import com.yahoo.vespa.config.server.http.ContentHandler;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.v2.ApplicationContentRequest;
import com.yahoo.vespa.config.server.tenant.Tenant;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationHandler
extends HttpHandler {
    private static final List<UriPattern> URI_PATTERNS = Stream.of("http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/content/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/filedistributionstatus", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/restart", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/reindex", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/reindexing", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/suspended", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/serviceconverge", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/serviceconverge/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/clustercontroller/*/status/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/metrics/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/metrics/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/logs", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/tester/*/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/tester/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/quota", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*", "http://*/application/v2/tenant/*/application/*").map(UriPattern::new).collect(Collectors.toList());
    private final Zone zone;
    private final ApplicationRepository applicationRepository;

    @Inject
    public ApplicationHandler(LoggingRequestHandler.Context ctx, Zone zone, ApplicationRepository applicationRepository) {
        super(ctx);
        this.zone = zone;
        this.applicationRepository = applicationRepository;
    }

    @Override
    public HttpResponse handleDELETE(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        if (ApplicationHandler.isReindexingRequest(request)) {
            this.applicationRepository.modifyReindexing(applicationId, reindexing -> reindexing.enabled(false));
            return ApplicationHandler.createMessageResponse("Reindexing disabled");
        }
        if (this.applicationRepository.delete(applicationId)) {
            return new DeleteApplicationResponse(200, applicationId);
        }
        return HttpErrorResponse.notFoundError("Unable to delete " + applicationId.toFullString() + ": Not found");
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        Duration timeout = HttpHandler.getRequestTimeout(request, Duration.ofSeconds(5L));
        if (ApplicationHandler.isServiceConvergeRequest(request)) {
            String hostAndPort = ApplicationHandler.getHostNameFromRequest(request);
            return this.applicationRepository.checkServiceForConfigConvergence(applicationId, hostAndPort, request.getUri(), timeout, ApplicationHandler.getVespaVersionFromRequest(request));
        }
        if (ApplicationHandler.isClusterControllerStatusRequest(request)) {
            String hostName = ApplicationHandler.getHostNameFromRequest(request);
            String pathSuffix = URLDecoder.decode(ApplicationHandler.getPathSuffix(request), StandardCharsets.UTF_8);
            return this.applicationRepository.clusterControllerStatusPage(applicationId, hostName, pathSuffix);
        }
        if (ApplicationHandler.isReindexingRequest(request)) {
            return this.getReindexingStatus(applicationId);
        }
        if (ApplicationHandler.isContentRequest(request)) {
            long sessionId = this.applicationRepository.getSessionIdForApplication(applicationId);
            String contentPath = ApplicationHandler.getBindingMatch(request).group(7);
            ApplicationFile applicationFile = this.applicationRepository.getApplicationFileFromSession(applicationId.tenant(), sessionId, contentPath, ContentRequest.getApplicationFileMode(request.getMethod()));
            ApplicationContentRequest contentRequest = new ApplicationContentRequest(request, sessionId, applicationId, this.zone, contentPath, applicationFile);
            return new ContentHandler().get(contentRequest);
        }
        if (ApplicationHandler.isServiceConvergeListRequest(request)) {
            return this.applicationRepository.servicesToCheckForConfigConvergence(applicationId, request.getUri(), timeout, ApplicationHandler.getVespaVersionFromRequest(request));
        }
        if (ApplicationHandler.isFiledistributionStatusRequest(request)) {
            return this.applicationRepository.filedistributionStatus(applicationId, timeout);
        }
        if (ApplicationHandler.isLogRequest(request)) {
            Optional<String> hostname = Optional.ofNullable(request.getProperty("hostname"));
            String apiParams = Optional.ofNullable(request.getUri().getQuery()).map(q -> "?" + q).orElse("");
            return this.applicationRepository.getLogs(applicationId, hostname, apiParams);
        }
        if (ApplicationHandler.isProtonMetricsRequest(request)) {
            return this.applicationRepository.getProtonMetrics(applicationId);
        }
        if (ApplicationHandler.isDeploymentMetricsRequest(request)) {
            return this.applicationRepository.getDeploymentMetrics(applicationId);
        }
        if (ApplicationHandler.isIsSuspendedRequest(request)) {
            return new ApplicationSuspendedResponse(this.applicationRepository.isSuspended(applicationId));
        }
        if (ApplicationHandler.isTesterRequest(request)) {
            String testerCommand;
            switch (testerCommand = ApplicationHandler.getTesterCommandFromRequest(request)) {
                case "status": {
                    return this.applicationRepository.getTesterStatus(applicationId);
                }
                case "log": {
                    Long after = Long.valueOf(request.getProperty("after"));
                    return this.applicationRepository.getTesterLog(applicationId, after);
                }
                case "ready": {
                    return this.applicationRepository.isTesterReady(applicationId);
                }
                case "report": {
                    return this.applicationRepository.getTestReport(applicationId);
                }
            }
            throw new IllegalArgumentException("Unknown tester command in request " + request.getUri().toString());
        }
        if (ApplicationHandler.isQuotaUsageRequest(request)) {
            double quotaUsageRate = this.applicationRepository.getQuotaUsageRate(applicationId);
            return new QuotaUsageResponse(quotaUsageRate);
        }
        return this.getApplicationResponse(applicationId);
    }

    GetApplicationResponse getApplicationResponse(ApplicationId applicationId) {
        return new GetApplicationResponse(200, this.applicationRepository.getApplicationGeneration(applicationId), this.applicationRepository.getAllVersions(applicationId), this.applicationRepository.getApplicationPackageReference(applicationId));
    }

    @Override
    public HttpResponse handlePOST(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        if (ApplicationHandler.isRestartRequest(request)) {
            return this.restart(request, applicationId);
        }
        if (ApplicationHandler.isTesterStartTestsRequest(request)) {
            byte[] data;
            try {
                data = IOUtils.readBytes((InputStream)request.getData(), (int)1024000);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read data in request " + request);
            }
            return this.applicationRepository.startTests(applicationId, ApplicationHandler.getSuiteFromRequest(request), data);
        }
        if (ApplicationHandler.isReindexRequest(request)) {
            return this.triggerReindexing(request, applicationId);
        }
        if (ApplicationHandler.isReindexingRequest(request)) {
            this.applicationRepository.modifyReindexing(applicationId, reindexing -> reindexing.enabled(true));
            return ApplicationHandler.createMessageResponse("Reindexing enabled");
        }
        throw new NotFoundException("Illegal POST request '" + request.getUri() + "'");
    }

    private Model getActiveModelOrThrow(ApplicationId id) {
        return this.applicationRepository.getActiveApplicationSet(id).orElseThrow(() -> new NotFoundException("Application '" + id + "' not found")).getForVersionOrLatest(Optional.empty(), this.applicationRepository.clock().instant()).getModel();
    }

    private HttpResponse triggerReindexing(HttpRequest request, ApplicationId applicationId) {
        Model model = this.getActiveModelOrThrow(applicationId);
        Map documentTypes = model.documentTypesByCluster();
        Map indexedDocumentTypes = model.indexedDocumentTypesByCluster();
        boolean indexedOnly = request.getBooleanProperty("indexedOnly");
        Set clusters = StringUtilities.split((String)request.getProperty("clusterId"));
        Set types = StringUtilities.split((String)request.getProperty("documentType"));
        TreeMap reindexed = new TreeMap();
        Instant now = this.applicationRepository.clock().instant();
        this.applicationRepository.modifyReindexing(applicationId, reindexing -> {
            for (String cluster : clusters.isEmpty() ? documentTypes.keySet() : clusters) {
                if (!documentTypes.containsKey(cluster)) {
                    throw new IllegalArgumentException("No content cluster '" + cluster + "' in application \u2014 only: " + String.join((CharSequence)", ", documentTypes.keySet()));
                }
                for (String type : types.isEmpty() ? (Set)documentTypes.get(cluster) : types) {
                    if (!((Set)documentTypes.get(cluster)).contains(type)) {
                        throw new IllegalArgumentException("No document type '" + type + "' in cluster '" + cluster + "' \u2014 only: " + String.join((CharSequence)", ", (Iterable)documentTypes.get(cluster)));
                    }
                    if (indexedOnly && !((Set)indexedDocumentTypes.get(cluster)).contains(type)) continue;
                    reindexing = reindexing.withReady(cluster, type, now);
                    reindexed.computeIfAbsent(cluster, __ -> new TreeSet()).add(type);
                }
            }
            return reindexing;
        });
        return ApplicationHandler.createMessageResponse(reindexed.entrySet().stream().filter(cluster -> !((Set)cluster.getValue()).isEmpty()).map(cluster -> "[" + String.join((CharSequence)", ", (Iterable)cluster.getValue()) + "] in '" + (String)cluster.getKey() + "'").reduce(new StringJoiner(", ", "Reindexing document types ", " of application " + applicationId).setEmptyValue("Not reindexing any document types of application " + applicationId), StringJoiner::add, StringJoiner::merge).toString());
    }

    private HttpResponse getReindexingStatus(ApplicationId applicationId) {
        Tenant tenant = this.applicationRepository.getTenant(applicationId);
        if (tenant == null) {
            throw new NotFoundException("Tenant '" + applicationId.tenant().value() + "' not found");
        }
        return new ReindexingResponse(this.getActiveModelOrThrow(applicationId).documentTypesByCluster(), this.applicationRepository.getReindexing(applicationId), this.applicationRepository.getClusterReindexingStatus(applicationId));
    }

    private HttpResponse restart(HttpRequest request, ApplicationId applicationId) {
        if (ApplicationHandler.getBindingMatch(request).groupCount() != 7) {
            throw new NotFoundException("Illegal POST restart request '" + request.getUri() + "': Must have 6 arguments but had " + (ApplicationHandler.getBindingMatch(request).groupCount() - 1));
        }
        this.applicationRepository.restart(applicationId, this.hostFilterFrom(request));
        return new JSONResponse(200);
    }

    private HostFilter hostFilterFrom(HttpRequest request) {
        return HostFilter.from((String)request.getProperty("hostname"), (String)request.getProperty("flavor"), (String)request.getProperty("clusterType"), (String)request.getProperty("clusterId"));
    }

    private static BindingMatch<?> getBindingMatch(HttpRequest request) {
        return URI_PATTERNS.stream().map(pattern -> {
            UriPattern.Match match = pattern.match(request.getUri());
            if (match == null) {
                return null;
            }
            return new BindingMatch(match, new Object(), pattern);
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("Illegal url for config request: " + request.getUri()));
    }

    private static boolean isRestartRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/restart");
    }

    private static boolean isReindexRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/reindex");
    }

    private static boolean isReindexingRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/reindexing");
    }

    private static boolean isIsSuspendedRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/suspended");
    }

    private static boolean isProtonMetricsRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().endsWith("/metrics/proton");
    }

    private static boolean isDeploymentMetricsRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().endsWith("/metrics/deployment");
    }

    private static boolean isLogRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/logs");
    }

    private static boolean isServiceConvergeListRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/serviceconverge");
    }

    private static boolean isServiceConvergeRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().contains("/serviceconverge/");
    }

    private static boolean isClusterControllerStatusRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 9 && request.getUri().getPath().contains("/clustercontroller/");
    }

    private static boolean isContentRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() > 7 && request.getUri().getPath().contains("/content/");
    }

    private static boolean isFiledistributionStatusRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().contains("/filedistributionstatus");
    }

    private static boolean isTesterRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().contains("/tester");
    }

    private static boolean isTesterStartTestsRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 9 && request.getUri().getPath().contains("/tester/run/");
    }

    private static boolean isQuotaUsageRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/quota");
    }

    private static String getHostNameFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(7);
    }

    private static String getTesterCommandFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(7);
    }

    private static String getSuiteFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(8);
    }

    private static String getPathSuffix(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(8);
    }

    private static ApplicationId getApplicationIdFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        if (bm.groupCount() > 4) {
            return ApplicationHandler.createFromRequestFullAppId(bm);
        }
        return ApplicationHandler.createFromRequestSimpleAppId(bm);
    }

    private static ApplicationId createFromRequestSimpleAppId(BindingMatch<?> bm) {
        TenantName tenant = TenantName.from((String)bm.group(2));
        ApplicationName application = ApplicationName.from((String)bm.group(3));
        return new ApplicationId.Builder().tenant(tenant).applicationName(application).build();
    }

    private static ApplicationId createFromRequestFullAppId(BindingMatch<?> bm) {
        String tenant = bm.group(2);
        String application = bm.group(3);
        String instance = bm.group(6);
        return new ApplicationId.Builder().tenant(tenant).applicationName(application).instanceName(instance).build();
    }

    private static Optional<Version> getVespaVersionFromRequest(HttpRequest request) {
        String vespaVersion = request.getProperty("vespaVersion");
        return vespaVersion == null || vespaVersion.isEmpty() ? Optional.empty() : Optional.of(Version.fromString((String)vespaVersion));
    }

    private static JSONResponse createMessageResponse(final String message) {
        return new JSONResponse(200){
            {
                super(status);
                this.object.setString("message", message);
            }
        };
    }

    static class ReindexingResponse
    extends JSONResponse {
        ReindexingResponse(Map<String, Set<String>> documentTypes, ApplicationReindexing reindexing, Map<String, ClusterReindexing> clusters) {
            super(200);
            this.object.setBool("enabled", reindexing.enabled());
            Cursor clustersObject = this.object.setObject("clusters");
            documentTypes.forEach((cluster, types) -> {
                Cursor clusterObject = clustersObject.setObject(cluster);
                Cursor pendingObject = clusterObject.setObject("pending");
                Cursor readyObject = clusterObject.setObject("ready");
                for (String type : types) {
                    Cursor statusObject = readyObject.setObject(type);
                    if (reindexing.clusters().containsKey(cluster)) {
                        if (reindexing.clusters().get(cluster).pending().containsKey(type)) {
                            pendingObject.setLong(type, reindexing.clusters().get(cluster).pending().get(type).longValue());
                        }
                        if (reindexing.clusters().get(cluster).ready().containsKey(type)) {
                            ReindexingResponse.setStatus(statusObject, reindexing.clusters().get(cluster).ready().get(type));
                        }
                    }
                    if (!clusters.containsKey(cluster) || !((ClusterReindexing)clusters.get(cluster)).documentTypeStatus().containsKey(type)) continue;
                    ReindexingResponse.setStatus(statusObject, ((ClusterReindexing)clusters.get(cluster)).documentTypeStatus().get(type));
                }
            });
        }

        private static void setStatus(Cursor object, ApplicationReindexing.Status readyStatus) {
            object.setLong("readyMillis", readyStatus.ready().toEpochMilli());
        }

        private static void setStatus(Cursor object, ClusterReindexing.Status status) {
            object.setLong("startedMillis", status.startedAt().toEpochMilli());
            status.endedAt().ifPresent(endedAt -> object.setLong("endedMillis", endedAt.toEpochMilli()));
            status.state().map(ClusterReindexing.State::asString).ifPresent(state -> object.setString("state", state));
            status.message().ifPresent(message -> object.setString("message", message));
            status.progress().ifPresent(progress -> object.setDouble("progress", progress.doubleValue()));
        }
    }

    private static class QuotaUsageResponse
    extends JSONResponse {
        QuotaUsageResponse(double usageRate) {
            super(200);
            this.object.setDouble("rate", usageRate);
        }
    }

    private static class ApplicationSuspendedResponse
    extends JSONResponse {
        ApplicationSuspendedResponse(boolean suspended) {
            super(200);
            this.object.setBool("suspended", suspended);
        }
    }

    private static class GetApplicationResponse
    extends JSONResponse {
        GetApplicationResponse(int status, long generation, List<Version> modelVersions, Optional<String> applicationPackageReference) {
            super(status);
            this.object.setLong("generation", generation);
            this.object.setString("applicationPackageFileReference", applicationPackageReference.orElse(""));
            Cursor modelVersionArray = this.object.setArray("modelVersions");
            modelVersions.forEach(version -> modelVersionArray.addString(version.toFullString()));
        }
    }

    private static class DeleteApplicationResponse
    extends JSONResponse {
        DeleteApplicationResponse(int status, ApplicationId applicationId) {
            super(status);
            this.object.setString("message", "Application '" + applicationId + "' deleted");
        }
    }
}

