/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.curator.Curator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigCurator {
    public static final String DEFCONFIGS_ZK_SUBPATH = "/defconfigs";
    public static final String USER_DEFCONFIGS_ZK_SUBPATH = "/userdefconfigs";
    public static final String META_ZK_PATH = "/meta";
    public static final String USERAPP_ZK_SUBPATH = "/userapp";
    public static final String SESSIONSTATE_ZK_SUBPATH = "/sessionState";
    private final Curator curator;
    public static final Logger log = Logger.getLogger(ConfigCurator.class.getName());
    private final int maxNodeSize;

    public static ConfigCurator create(Curator curator) {
        return new ConfigCurator(curator, 0xA00000);
    }

    @Inject
    public ConfigCurator(Curator curator, ZookeeperServerConfig config) {
        this(curator, config.juteMaxBuffer());
    }

    private ConfigCurator(Curator curator, int maxNodeSize) {
        this.curator = curator;
        this.maxNodeSize = maxNodeSize;
        log.log(Level.CONFIG, "Using jute max buffer size " + this.maxNodeSize);
        this.testZkConnection();
    }

    public Curator curator() {
        return this.curator;
    }

    void initAndClear(String path) {
        try {
            if (this.exists(path)) {
                this.deleteRecurse(path);
            }
            this.createRecurse(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception clearing path " + path + " in ZooKeeper", e);
        }
    }

    private void createRecurse(String path) {
        try {
            if (this.exists(path)) {
                return;
            }
            this.curator.framework().create().creatingParentsIfNeeded().forPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception creating path " + path + " in ZooKeeper", e);
        }
    }

    public String getData(String path, String node) {
        return this.getData(this.createFullPath(path, node));
    }

    public String getData(String path) {
        byte[] data = this.getBytes(path);
        return data == null ? null : Utf8.toString((byte[])data);
    }

    public byte[] getBytes(String path) {
        try {
            if (!this.exists(path)) {
                return null;
            }
            return (byte[])this.curator.framework().getData().forPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception reading from path " + path + " in ZooKeeper", e);
        }
    }

    public boolean exists(String path, String node) {
        return this.exists(this.createFullPath(path, node));
    }

    public boolean exists(String path) {
        try {
            return this.curator.framework().checkExists().forPath(path) != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception checking existence of path " + path + " in ZooKeeper", e);
        }
    }

    public void createNode(String path) {
        if (!this.exists(path)) {
            this.createRecurse(path);
        }
    }

    public void createNode(String path, String node) {
        this.createNode(this.createFullPath(path, node));
    }

    private String createFullPath(String path, String node) {
        return path + "/" + this.toConfigserverName(node);
    }

    public void putData(String path, String node, String data) {
        this.putData(path, node, Utf8.toBytes((String)data));
    }

    public void putData(String path, String data) {
        this.putData(path, Utf8.toBytes((String)data));
    }

    private void ensureDataIsNotTooLarge(byte[] toPut, String path) {
        if (toPut.length >= this.maxNodeSize) {
            throw new IllegalArgumentException("Error: too much zookeeper data in node: [" + toPut.length + " bytes] (path " + path + ")");
        }
    }

    private void putData(String path, String node, byte[] data) {
        this.putData(this.createFullPath(path, node), data);
    }

    public void putData(String path, byte[] data) {
        try {
            this.ensureDataIsNotTooLarge(data, path);
            if (this.exists(path)) {
                this.curator.framework().setData().forPath(path, data);
            } else {
                this.curator.framework().create().creatingParentsIfNeeded().forPath(path, data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception writing to path " + path + " in ZooKeeper", e);
        }
    }

    private String toConfigserverName(String node) {
        if (node.startsWith("/")) {
            node = node.substring(1);
        }
        return node.replaceAll("/", "#");
    }

    public List<String> getChildren(String path) {
        try {
            return (List)this.curator.framework().getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception getting children of path " + path + " in ZooKeeper", e);
        }
    }

    public void putDefData(String name, String path, byte[] data) {
        this.putData(path, name, data);
    }

    public void deleteRecurse(String path) {
        try {
            if (!this.exists(path)) {
                return;
            }
            this.curator.framework().delete().deletingChildrenIfNeeded().forPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception deleting path " + path, e);
        }
    }

    private void testZkConnection() {
        if (this.curator.connectionSpec().isEmpty()) {
            return;
        }
        try {
            this.curator.framework().checkExists().forPath("/dummy");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to connect to ZooKeeper on " + this.curator.connectionSpec() + ". Please verify that VESPA_CONFIGSERVERS points to the correct configserver(s) on all config server nodes and are the same config server(s) as in services.xml, and that they are started. Check the log(s) for config server errors. Aborting.", e);
        }
    }
}

