/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.monitoring;

import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZKMetricUpdater
implements Runnable {
    private static final Logger log = Logger.getLogger(ZKMetricUpdater.class.getName());
    public static final String METRIC_ZK_ZNODES = Metrics.getMetricName("zkZNodes");
    public static final String METRIC_ZK_LATENCY_AVERAGE = Metrics.getMetricName("zkAvgLatency");
    public static final String METRIC_ZK_LATENCY_MAX = Metrics.getMetricName("zkMaxLatency");
    public static final String METRIC_ZK_CONNECTIONS = Metrics.getMetricName("zkConnections");
    public static final String METRIC_ZK_OUTSTANDING_REQUESTS = Metrics.getMetricName("zkOutstandingRequests");
    private static final int CONNECTION_TIMEOUT_MS = 1000;
    private static final int WRITE_TIMEOUT_MS = 500;
    private static final int READ_TIMEOUT_MS = 1000;
    private final AtomicReference<Map<String, Long>> zkMetrics = new AtomicReference(new HashMap());
    private final ScheduledExecutorService executorService;
    private final int zkPort;
    private static final Pattern MONITORING_REPORT = Pattern.compile("^(\\w+)\\s+(\\d+)$", 8);

    public ZKMetricUpdater(ZookeeperServerConfig zkServerConfig, long delayMS, long intervalMS) {
        this.zkPort = zkServerConfig.clientPort();
        if (intervalMS <= 0L) {
            throw new IllegalArgumentException("interval must be positive, was " + intervalMS + " ms");
        }
        this.executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("zkmetricupdater"));
        this.executorService.scheduleAtFixedRate(this, delayMS, intervalMS, TimeUnit.MILLISECONDS);
    }

    private void setMetricAttribute(String attribute, long value, Map<String, Long> data) {
        switch (attribute) {
            case "zk_znode_count": {
                data.put(METRIC_ZK_ZNODES, value);
                break;
            }
            case "zk_avg_latency": {
                data.put(METRIC_ZK_LATENCY_AVERAGE, value);
                break;
            }
            case "zk_max_latency": {
                data.put(METRIC_ZK_LATENCY_MAX, value);
                break;
            }
            case "zk_num_alive_connections": {
                data.put(METRIC_ZK_CONNECTIONS, value);
                break;
            }
            case "zk_outstanding_requests": {
                data.put(METRIC_ZK_OUTSTANDING_REQUESTS, value);
            }
        }
    }

    @Override
    public void run() {
        Optional<String> report = this.retrieveReport();
        report.ifPresent(this::parseReport);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    private Optional<String> retrieveReport() {
        Optional<String> optional;
        block9: {
            AsynchronousSocketChannel chan = AsynchronousSocketChannel.open();
            try {
                InetSocketAddress zkAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), this.zkPort);
                Future<Void> connected = chan.connect(zkAddress);
                connected.get(1000L, TimeUnit.MILLISECONDS);
                Future<Integer> written = chan.write(ByteBuffer.wrap("mntr\n".getBytes(StandardCharsets.UTF_8)));
                written.get(500L, TimeUnit.MILLISECONDS);
                int nread = -1;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                do {
                    Future<Integer> read = chan.read(buffer);
                    nread = read.get(1000L, TimeUnit.MILLISECONDS);
                    buffer.flip();
                    baos.write(buffer.array());
                    buffer.clear();
                } while (nread >= 0);
                optional = Optional.of(baos.toString(StandardCharsets.UTF_8));
                if (chan == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (chan != null) {
                        try {
                            chan.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                    log.warning("Failure in retrieving monitoring data: (" + e.getClass().getSimpleName() + ") " + e.getMessage());
                    return Optional.empty();
                }
            }
            chan.close();
        }
        return optional;
    }

    private void parseReport(String report) {
        Matcher matcher = MONITORING_REPORT.matcher(report);
        HashMap<String, Long> data = new HashMap<String, Long>();
        while (matcher.find()) {
            String attribute = matcher.group(1);
            long value = Long.parseLong(matcher.group(2));
            this.setMetricAttribute(attribute, value, data);
        }
        this.zkMetrics.set(data);
    }

    public Map<String, Long> getZKMetrics() {
        return this.zkMetrics.get();
    }
}

