/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.config.model.api.Reindexing;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationReindexing
implements Reindexing {
    private final boolean enabled;
    private final Status common;
    private final Map<String, Cluster> clusters;

    ApplicationReindexing(boolean enabled, Status common, Map<String, Cluster> clusters) {
        this.enabled = enabled;
        this.common = Objects.requireNonNull(common);
        this.clusters = Map.copyOf(clusters);
    }

    public static ApplicationReindexing ready(Instant now) {
        return new ApplicationReindexing(true, new Status(now), Map.of());
    }

    public ApplicationReindexing withReady(Instant readyAt) {
        return new ApplicationReindexing(this.enabled, new Status(readyAt), this.clusters.entrySet().stream().filter(cluster -> !((Cluster)cluster.getValue()).pending.isEmpty()).collect(Collectors.toUnmodifiableMap(cluster -> (String)cluster.getKey(), cluster -> new Cluster(new Status(readyAt), ((Cluster)cluster.getValue()).pending, Map.of()))));
    }

    public ApplicationReindexing withReady(String cluster, Instant readyAt) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.ready(this.common));
        Cluster modified = new Cluster(new Status(readyAt), current.pending, Map.of());
        return new ApplicationReindexing(this.enabled, this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withReady(String cluster, String documentType, Instant readyAt) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.ready(this.common));
        Cluster modified = new Cluster(current.common, current.pending, ApplicationReindexing.with(documentType, new Status(readyAt), current.ready));
        return new ApplicationReindexing(this.enabled, this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withPending(String cluster, String documentType, long requiredGeneration) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.ready(this.common));
        Cluster modified = new Cluster(current.common, ApplicationReindexing.with(documentType, ApplicationReindexing.requirePositive(requiredGeneration), current.pending), current.ready);
        return new ApplicationReindexing(this.enabled, this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing withoutPending(String cluster, String documentType) {
        Cluster current = this.clusters.getOrDefault(cluster, Cluster.ready(this.common));
        if (current == null) {
            return this;
        }
        Cluster modified = new Cluster(current.common, ApplicationReindexing.without(documentType, current.pending), current.ready);
        return new ApplicationReindexing(this.enabled, this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing without(String cluster) {
        return new ApplicationReindexing(this.enabled, this.common, ApplicationReindexing.without(cluster, this.clusters));
    }

    public ApplicationReindexing without(String cluster, String documentType) {
        Cluster current = this.clusters.get(cluster);
        if (current == null) {
            return this;
        }
        Cluster modified = new Cluster(current.common, current.pending, ApplicationReindexing.without(documentType, current.ready));
        return new ApplicationReindexing(this.enabled, this.common, ApplicationReindexing.with(cluster, modified, this.clusters));
    }

    public ApplicationReindexing enabled(boolean enabled) {
        return new ApplicationReindexing(enabled, this.common, this.clusters);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Status common() {
        return this.common;
    }

    public Map<String, Cluster> clusters() {
        return this.clusters;
    }

    public Optional<Reindexing.Status> status(String cluster, String documentType) {
        return !this.clusters.containsKey(cluster) ? Optional.of(this.common()) : (!this.clusters.get(cluster).ready().containsKey(documentType) ? Optional.of(this.clusters.get(cluster).common()) : Optional.of((Reindexing.Status)this.clusters.get(cluster).ready().get(documentType)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationReindexing that = (ApplicationReindexing)o;
        return this.enabled == that.enabled && this.common.equals(that.common) && this.clusters.equals(that.clusters);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.common, this.clusters);
    }

    public String toString() {
        return "ApplicationReindexing{enabled=" + this.enabled + ", common=" + this.common + ", clusters=" + this.clusters + "}";
    }

    private static long requirePositive(long generation) {
        if (generation <= 0L) {
            throw new IllegalArgumentException("Generation must be positive, but was " + generation);
        }
        return generation;
    }

    private static <T> Map<String, T> without(String removed, Map<String, T> map) {
        return map.keySet().stream().filter(key -> !removed.equals(key)).collect(Collectors.toUnmodifiableMap(key -> key, key -> map.get(key)));
    }

    private static <T> Map<String, T> with(String added, T value, Map<String, T> map) {
        return Stream.concat(Stream.of(added), map.keySet().stream()).distinct().collect(Collectors.toUnmodifiableMap(key -> key, key -> added.equals(key) ? value : map.get(key)));
    }

    public static class Status
    implements Reindexing.Status {
        private final Instant ready;

        Status(Instant ready) {
            this.ready = ready.truncatedTo(ChronoUnit.MILLIS);
        }

        public Instant ready() {
            return this.ready;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.ready.equals(status.ready);
        }

        public int hashCode() {
            return Objects.hash(this.ready);
        }

        public String toString() {
            return "ready at " + this.ready;
        }
    }

    public static class Cluster {
        private final Status common;
        private final Map<String, Long> pending;
        private final Map<String, Status> ready;

        private static Cluster ready(Status common) {
            return new Cluster(common, Map.of(), Map.of());
        }

        Cluster(Status common, Map<String, Long> pending, Map<String, Status> ready) {
            this.common = Objects.requireNonNull(common);
            this.pending = Map.copyOf(pending);
            this.ready = Map.copyOf(ready);
        }

        public Status common() {
            return this.common;
        }

        public Map<String, Long> pending() {
            return this.pending;
        }

        public Map<String, Status> ready() {
            return this.ready;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cluster cluster = (Cluster)o;
            return this.common.equals(cluster.common) && this.pending.equals(cluster.pending) && this.ready.equals(cluster.ready);
        }

        public int hashCode() {
            return Objects.hash(this.common, this.pending, this.ready);
        }

        public String toString() {
            return "Cluster{common=" + this.common + ", pending=" + this.pending + ", ready=" + this.ready + "}";
        }
    }
}

