/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ClusterReindexing {
    private static final ClusterReindexing empty = new ClusterReindexing(Map.of());
    private final Map<String, Status> documentTypeStatus;

    public ClusterReindexing(Map<String, Status> documentTypeStatus) {
        this.documentTypeStatus = Map.copyOf(documentTypeStatus);
    }

    public static ClusterReindexing empty() {
        return empty;
    }

    public Map<String, Status> documentTypeStatus() {
        return this.documentTypeStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterReindexing that = (ClusterReindexing)o;
        return this.documentTypeStatus.equals(that.documentTypeStatus);
    }

    public int hashCode() {
        return Objects.hash(this.documentTypeStatus);
    }

    public String toString() {
        return "ClusterReindexing{documentTypeStatus=" + this.documentTypeStatus + "}";
    }

    public static enum State {
        PENDING("pending"),
        RUNNING("running"),
        FAILED("failed"),
        SUCCESSFUL("successful");

        private final String stringValue;

        private State(String stringValue) {
            this.stringValue = stringValue;
        }

        public static State fromString(String value) {
            return Arrays.stream(State.values()).filter(v -> v.stringValue.equals(value)).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown value: " + value));
        }

        public String asString() {
            return this.stringValue;
        }
    }

    public static class Status {
        private final Instant startedAt;
        private final Instant endedAt;
        private final State state;
        private final String message;
        private final Double progress;

        public Status(Instant startedAt, Instant endedAt, State state, String message, Double progress) {
            this.startedAt = Objects.requireNonNull(startedAt);
            this.endedAt = endedAt;
            this.state = state;
            this.message = message;
            this.progress = progress;
        }

        public Instant startedAt() {
            return this.startedAt;
        }

        public Optional<Instant> endedAt() {
            return Optional.ofNullable(this.endedAt);
        }

        public Optional<State> state() {
            return Optional.ofNullable(this.state);
        }

        public Optional<String> message() {
            return Optional.ofNullable(this.message);
        }

        public Optional<Double> progress() {
            return Optional.ofNullable(this.progress);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.startedAt.equals(status.startedAt) && Objects.equals(this.endedAt, status.endedAt) && this.state == status.state && Objects.equals(this.message, status.message) && Objects.equals(this.progress, status.progress);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.startedAt, this.endedAt, this.state, this.message, this.progress});
        }

        public String toString() {
            return "Status{startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ", state=" + this.state + ", message='" + this.message + "', progress='" + this.progress + "'}";
        }
    }
}

