/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpConfigRequest;
import com.yahoo.vespa.config.server.http.HttpConfigResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Optional;
import java.util.logging.Level;

public class HttpGetConfigHandler
extends HttpHandler {
    private final TenantRepository tenantRepository;

    @Inject
    public HttpGetConfigHandler(LoggingRequestHandler.Context ctx, TenantRepository tenantRepository) {
        super(ctx);
        this.tenantRepository = tenantRepository;
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        HttpConfigRequest request = HttpConfigRequest.createFromRequestV2(req);
        RequestHandler requestHandler = HttpConfigRequests.getRequestHandler(this.tenantRepository, request);
        HttpConfigRequest.validateRequestKey(request.getConfigKey(), requestHandler, request.getApplicationId());
        return HttpConfigResponse.createFromConfig(this.resolveConfig(request, requestHandler));
    }

    private ConfigResponse resolveConfig(HttpConfigRequest request, RequestHandler requestHandler) {
        this.log.log(Level.FINE, "nocache=" + request.noCache());
        ConfigResponse config = requestHandler.resolveConfig(request.getApplicationId(), request, Optional.empty());
        if (config == null) {
            HttpConfigRequest.throwModelNotReady();
        }
        return config;
    }
}

