/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.buildergen.ConfigDefinition;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.server.UnknownConfigDefinitionException;
import com.yahoo.vespa.config.server.model.SuperModelConfigProvider;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import java.io.Reader;
import java.io.StringReader;

public class SuperModelController {
    private final SuperModelConfigProvider model;
    private final long generation;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final ConfigResponseFactory responseFactory;

    public SuperModelController(SuperModelConfigProvider model, ConfigDefinitionRepo configDefinitionRepo, long generation, ConfigResponseFactory responseFactory) {
        this.model = model;
        this.configDefinitionRepo = configDefinitionRepo;
        this.generation = generation;
        this.responseFactory = responseFactory;
    }

    public ConfigResponse resolveConfig(GetConfigRequest request) {
        ConfigKey configKey = request.getConfigKey();
        this.validateConfigDefinition(request.getConfigKey(), request.getDefContent());
        ConfigPayload payload = this.model.getConfig(configKey);
        return this.responseFactory.createResponse(payload, this.generation, false, false);
    }

    private void validateConfigDefinition(ConfigKey<?> configKey, DefContent defContent) {
        if (defContent.isEmpty()) {
            ConfigDefinitionKey configDefinitionKey = new ConfigDefinitionKey(configKey.getName(), configKey.getNamespace());
            ConfigDefinition configDefinition = (ConfigDefinition)this.configDefinitionRepo.getConfigDefinitions().get(configDefinitionKey);
            if (configDefinition == null) {
                throw new UnknownConfigDefinitionException("Unable to find config definition for '" + configKey.getNamespace() + "." + configKey.getName());
            }
        } else {
            DefParser dParser = new DefParser(configKey.getName(), (Reader)new StringReader(defContent.asString()));
            dParser.getTree();
        }
    }

    public SuperModelConfigProvider getSuperModel() {
        return this.model;
    }

    long getGeneration() {
        return this.generation;
    }
}

