/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.DoubleFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.Flag;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.IntFlag;
import com.yahoo.vespa.flags.StringFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final Optional<HostProvisioner> hostProvisioner;
    private final Provisioned provisioned;
    private final Optional<? extends Reindexing> reindexing;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, Optional<ApplicationPackage> permanentApplicationPackage, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, Optional<? extends Reindexing> reindexing, Optional<HostProvisioner> hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.reindexing = reindexing;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public Optional<ApplicationPackage> permanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public Optional<HostProvisioner> hostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public Optional<? extends Reindexing> reindexing() {
        return this.reindexing;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ModelContext.FeatureFlags featureFlags;
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final boolean useThreePhaseUpdates;
        private final boolean useDirectStorageApiRpc;
        private final boolean useFastValueTensorImplementation;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final double defaultTermwiseLimit;
        private final String jvmGCOPtions;
        private final String feedSequencer;
        private final String responseSequencer;
        private final int numResponseThreads;
        private final boolean skipCommunicationManagerThread;
        private final boolean skipMbusRequestThread;
        private final boolean skipMbusReplyThread;
        private final Optional<AthenzDomain> athenzDomain;
        private final Optional<ApplicationRoles> applicationRoles;
        private final Quota quota;
        private final boolean useAccessControlTlsHandshakeClientAuth;
        private final boolean useAsyncMessageHandlingOnSchedule;
        private final int contentNodeBucketDBStripeBits;
        private final int mergeChunkSize;
        private final double feedConcurrency;

        public Properties(ApplicationId applicationId, ConfigserverConfig configserverConfig, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain, Optional<ApplicationRoles> applicationRoles, Optional<Quota> maybeQuota) {
            this.featureFlags = new FeatureFlags(flagSource, applicationId);
            this.applicationId = applicationId;
            this.multitenant = configserverConfig.multitenant() || configserverConfig.hostedVespa() || Boolean.getBoolean("multitenant");
            this.configServerSpecs = ConfigServerSpec.fromConfig(configserverConfig);
            this.loadBalancerName = HostName.from((String)configserverConfig.loadBalancerAddress());
            this.ztsUrl = configserverConfig.ztsUrl() != null ? URI.create(configserverConfig.ztsUrl()) : null;
            this.athenzDnsSuffix = configserverConfig.athenzDnsSuffix();
            this.hostedVespa = configserverConfig.hostedVespa();
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.defaultTermwiseLimit = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_TERM_WISE_LIMIT.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useThreePhaseUpdates = ((BooleanFlag)((BooleanFlag)Flags.USE_THREE_PHASE_UPDATES.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useDirectStorageApiRpc = ((BooleanFlag)((BooleanFlag)Flags.USE_DIRECT_STORAGE_API_RPC.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useFastValueTensorImplementation = ((BooleanFlag)((BooleanFlag)Flags.USE_FAST_VALUE_TENSOR_IMPLEMENTATION.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.jvmGCOPtions = ((StringFlag)((StringFlag)Flags.JVM_GC_OPTIONS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.feedSequencer = ((StringFlag)((StringFlag)Flags.FEED_SEQUENCER_TYPE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.responseSequencer = ((StringFlag)((StringFlag)Flags.RESPONSE_SEQUENCER_TYPE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.numResponseThreads = ((IntFlag)((IntFlag)Flags.RESPONSE_NUM_THREADS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.skipCommunicationManagerThread = ((BooleanFlag)((BooleanFlag)Flags.SKIP_COMMUNICATIONMANAGER_THREAD.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.skipMbusRequestThread = ((BooleanFlag)((BooleanFlag)Flags.SKIP_MBUS_REQUEST_THREAD.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.skipMbusReplyThread = ((BooleanFlag)((BooleanFlag)Flags.SKIP_MBUS_REPLY_THREAD.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.athenzDomain = athenzDomain;
            this.applicationRoles = applicationRoles;
            this.quota = maybeQuota.orElseGet(Quota::unlimited);
            this.useAccessControlTlsHandshakeClientAuth = ((BooleanFlag)((BooleanFlag)Flags.USE_ACCESS_CONTROL_CLIENT_AUTHENTICATION.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useAsyncMessageHandlingOnSchedule = ((BooleanFlag)((BooleanFlag)Flags.USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.contentNodeBucketDBStripeBits = ((IntFlag)((IntFlag)Flags.CONTENT_NODE_BUCKET_DB_STRIPE_BITS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.mergeChunkSize = ((IntFlag)((IntFlag)Flags.MERGE_CHUNK_SIZE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.feedConcurrency = ((DoubleFlag)((DoubleFlag)Flags.FEED_CONCURRENCY.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
        }

        public ModelContext.FeatureFlags featureFlags() {
            return this.featureFlags;
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<com.yahoo.config.model.api.ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public double defaultTermwiseLimit() {
            return this.defaultTermwiseLimit;
        }

        public boolean useThreePhaseUpdates() {
            return this.useThreePhaseUpdates;
        }

        public boolean useDirectStorageApiRpc() {
            return this.useDirectStorageApiRpc;
        }

        public boolean useFastValueTensorImplementation() {
            return this.useFastValueTensorImplementation;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }

        public Optional<ApplicationRoles> applicationRoles() {
            return this.applicationRoles;
        }

        public String jvmGCOptions() {
            return this.jvmGCOPtions;
        }

        public String feedSequencerType() {
            return this.feedSequencer;
        }

        public String responseSequencerType() {
            return this.responseSequencer;
        }

        public int defaultNumResponseThreads() {
            return this.numResponseThreads;
        }

        public boolean skipCommunicationManagerThread() {
            return this.skipCommunicationManagerThread;
        }

        public boolean skipMbusRequestThread() {
            return this.skipMbusRequestThread;
        }

        public boolean skipMbusReplyThread() {
            return this.skipMbusReplyThread;
        }

        public Quota quota() {
            return this.quota;
        }

        public boolean useAccessControlTlsHandshakeClientAuth() {
            return this.useAccessControlTlsHandshakeClientAuth;
        }

        public boolean useAsyncMessageHandlingOnSchedule() {
            return this.useAsyncMessageHandlingOnSchedule;
        }

        public int contentNodeBucketDBStripeBits() {
            return this.contentNodeBucketDBStripeBits;
        }

        public int mergeChunkSize() {
            return this.mergeChunkSize;
        }

        public double feedConcurrency() {
            return this.feedConcurrency;
        }
    }

    public static class FeatureFlags
    implements ModelContext.FeatureFlags {
        private final boolean enableAutomaticReindexing;

        public FeatureFlags(FlagSource source, ApplicationId appId) {
            this.enableAutomaticReindexing = (Boolean)FeatureFlags.flagValue(source, appId, Flags.ENABLE_AUTOMATIC_REINDEXING);
        }

        public boolean enableAutomaticReindexing() {
            return this.enableAutomaticReindexing;
        }

        private static <V> V flagValue(FlagSource source, ApplicationId appId, UnboundFlag<? extends V, ?, ?> flag) {
            return (V)((Flag)flag.bindTo(source).with(FetchVector.Dimension.APPLICATION_ID, appId.serializedForm())).boxedValue();
        }
    }
}

