/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Duration;

public class SessionsMaintainer
extends ConfigServerMaintainer {
    private final boolean hostedVespa;
    private int iteration = 0;

    SessionsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, Duration.ofMinutes(1L), interval);
        this.hostedVespa = applicationRepository.configserverConfig().hostedVespa();
    }

    protected boolean maintain() {
        if (this.iteration % 10 == 0) {
            this.log.log(LogLevel.INFO, () -> "Running " + SessionsMaintainer.class.getSimpleName() + ", iteration " + this.iteration);
        }
        this.applicationRepository.deleteExpiredLocalSessions();
        if (this.hostedVespa) {
            Duration expiryTime = Duration.ofMinutes(90L);
            int deleted = this.applicationRepository.deleteExpiredRemoteSessions(expiryTime);
            this.log.log(LogLevel.FINE, () -> "Deleted " + deleted + " expired remote sessions older than " + expiryTime);
        }
        ++this.iteration;
        return true;
    }
}

