/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.configchange;

import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RefeedActions;
import com.yahoo.vespa.config.server.configchange.ReindexActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import java.util.Set;

public class ConfigChangeActionsSlimeConverter {
    private final ConfigChangeActions actions;

    public ConfigChangeActionsSlimeConverter(ConfigChangeActions actions) {
        this.actions = actions;
    }

    public void toSlime(Cursor root) {
        Cursor actionsCursor = root.setObject("configChangeActions");
        this.restartActionsToSlime(actionsCursor);
        this.refeedActionsToSlime(actionsCursor);
        this.reindexActionsToSlime(actionsCursor);
    }

    private void restartActionsToSlime(Cursor actionsCursor) {
        Cursor restartCursor = actionsCursor.setArray("restart");
        for (RestartActions.Entry entry : this.actions.getRestartActions().getEntries()) {
            Cursor entryCursor = restartCursor.addObject();
            entryCursor.setString("clusterName", entry.getClusterName());
            entryCursor.setString("clusterType", entry.getClusterType());
            entryCursor.setString("serviceType", entry.getServiceType());
            ConfigChangeActionsSlimeConverter.messagesToSlime(entryCursor, entry.getMessages());
            ConfigChangeActionsSlimeConverter.servicesToSlime(entryCursor, entry.getServices());
        }
    }

    private void refeedActionsToSlime(Cursor actionsCursor) {
        Cursor refeedCursor = actionsCursor.setArray("refeed");
        for (RefeedActions.Entry entry : this.actions.getRefeedActions().getEntries()) {
            Cursor entryCursor = refeedCursor.addObject();
            entryCursor.setString("name", entry.name());
            entryCursor.setBool("allowed", entry.allowed());
            entryCursor.setString("documentType", entry.getDocumentType());
            entryCursor.setString("clusterName", entry.getClusterName());
            ConfigChangeActionsSlimeConverter.messagesToSlime(entryCursor, entry.getMessages());
            ConfigChangeActionsSlimeConverter.servicesToSlime(entryCursor, entry.getServices());
        }
    }

    private void reindexActionsToSlime(Cursor actionsCursor) {
        Cursor refeedCursor = actionsCursor.setArray("reindex");
        for (ReindexActions.Entry entry : this.actions.getReindexActions().getEntries()) {
            Cursor entryCursor = refeedCursor.addObject();
            entryCursor.setString("name", entry.name());
            entryCursor.setBool("allowed", entry.allowed());
            entryCursor.setString("documentType", entry.getDocumentType());
            entryCursor.setString("clusterName", entry.getClusterName());
            ConfigChangeActionsSlimeConverter.messagesToSlime(entryCursor, entry.getMessages());
            ConfigChangeActionsSlimeConverter.servicesToSlime(entryCursor, entry.getServices());
        }
    }

    private static void messagesToSlime(Cursor entryCursor, Set<String> messages) {
        Cursor messagesCursor = entryCursor.setArray("messages");
        for (String message : messages) {
            messagesCursor.addString(message);
        }
    }

    private static void servicesToSlime(Cursor entryCursor, Set<ServiceInfo> services) {
        Cursor servicesCursor = entryCursor.setArray("services");
        for (ServiceInfo service : services) {
            Cursor serviceCursor = servicesCursor.addObject();
            serviceCursor.setString("serviceName", service.getServiceName());
            serviceCursor.setString("serviceType", service.getServiceType());
            serviceCursor.setString("configId", service.getConfigId());
            serviceCursor.setString("hostName", service.getHostName());
        }
    }
}

