/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.component.Vtag;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateMetadata;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.secretstore.SecretStore;
import com.yahoo.lang.SettableOptional;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.PermanentApplicationPackage;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.deploy.ModelContextImpl;
import com.yahoo.vespa.config.server.deploy.ZooKeeperDeployer;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionFactory;
import com.yahoo.vespa.config.server.filedistribution.FileDistributionProvider;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.http.InvalidApplicationException;
import com.yahoo.vespa.config.server.modelfactory.ModelFactoryRegistry;
import com.yahoo.vespa.config.server.modelfactory.PreparedModelsBuilder;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.ApplicationRolesStore;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointsCache;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataSerializer;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataStore;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateRetriever;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class SessionPreparer {
    private static final Logger log = Logger.getLogger(SessionPreparer.class.getName());
    private final ModelFactoryRegistry modelFactoryRegistry;
    private final FileDistributionFactory fileDistributionFactory;
    private final HostProvisionerProvider hostProvisionerProvider;
    private final PermanentApplicationPackage permanentApplicationPackage;
    private final ConfigserverConfig configserverConfig;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final Curator curator;
    private final Zone zone;
    private final SecretStore secretStore;
    private final FlagSource flagSource;

    @Inject
    public SessionPreparer(ModelFactoryRegistry modelFactoryRegistry, FileDistributionFactory fileDistributionFactory, HostProvisionerProvider hostProvisionerProvider, PermanentApplicationPackage permanentApplicationPackage, ConfigserverConfig configserverConfig, ConfigDefinitionRepo configDefinitionRepo, Curator curator, Zone zone, FlagSource flagSource, SecretStore secretStore) {
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.fileDistributionFactory = fileDistributionFactory;
        this.hostProvisionerProvider = hostProvisionerProvider;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.configserverConfig = configserverConfig;
        this.configDefinitionRepo = configDefinitionRepo;
        this.curator = curator;
        this.zone = zone;
        this.secretStore = secretStore;
        this.flagSource = flagSource;
    }

    public PrepareResult prepare(HostValidator<ApplicationId> hostValidator, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> activeApplicationSet, Instant now, File serverDbSessionDir, ApplicationPackage applicationPackage, SessionZooKeeperClient sessionZooKeeperClient) {
        ApplicationId applicationId = params.getApplicationId();
        Preparation preparation = new Preparation(hostValidator, logger, params, activeApplicationSet, TenantRepository.getTenantPath(applicationId.tenant()), serverDbSessionDir, applicationPackage, sessionZooKeeperClient);
        preparation.preprocess();
        try {
            AllocatedHosts allocatedHosts = preparation.buildModels(now);
            preparation.makeResult(allocatedHosts);
            if (!params.isDryRun()) {
                preparation.writeStateZK(preparation.distributeApplicationPackage());
                preparation.writeEndpointCertificateMetadataZK();
                preparation.writeContainerEndpointsZK();
                preparation.writeApplicationRoles();
                preparation.distribute();
            }
            log.log(Level.FINE, () -> "time used " + params.getTimeoutBudget().timesUsed() + " : " + applicationId);
            return preparation.result();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidApplicationException("Invalid application package", e);
        }
    }

    private void writeStateToZooKeeper(SessionZooKeeperClient zooKeeperClient, ApplicationPackage applicationPackage, ApplicationId applicationId, Optional<FileReference> distributedApplicationPackage, Optional<DockerImage> dockerImageRepository, Version vespaVersion, DeployLogger deployLogger, Map<Version, FileRegistry> fileRegistryMap, AllocatedHosts allocatedHosts, Optional<AthenzDomain> athenzDomain, Optional<Quota> quota) {
        ZooKeeperDeployer zkDeployer = zooKeeperClient.createDeployer(deployLogger);
        try {
            zkDeployer.deploy(applicationPackage, fileRegistryMap, allocatedHosts);
            zooKeeperClient.writeApplicationId(applicationId);
            zooKeeperClient.writeApplicationPackageReference(distributedApplicationPackage);
            zooKeeperClient.writeVespaVersion(vespaVersion);
            zooKeeperClient.writeDockerImageRepository(dockerImageRepository);
            zooKeeperClient.writeAthenzDomain(athenzDomain);
            zooKeeperClient.writeQuota(quota);
        }
        catch (IOException | RuntimeException e) {
            zkDeployer.cleanup();
            throw new RuntimeException("Error preparing session", e);
        }
    }

    private static final class ReconciliatedHostAllocations {
        public ReconciliatedHostAllocations(List<PreparedModelsBuilder.PreparedModelResult> results) {
        }
    }

    static class PrepareResult {
        private final AllocatedHosts allocatedHosts;
        private final ImmutableList<PreparedModelsBuilder.PreparedModelResult> results;

        public PrepareResult(AllocatedHosts allocatedHosts, List<PreparedModelsBuilder.PreparedModelResult> results) {
            this.allocatedHosts = allocatedHosts;
            this.results = ImmutableList.copyOf(results);
        }

        public List<PreparedModelsBuilder.PreparedModelResult> asList() {
            return this.results;
        }

        public AllocatedHosts allocatedHosts() {
            return this.allocatedHosts;
        }

        public Map<Version, FileRegistry> getFileRegistries() {
            return this.results.stream().collect(Collectors.toMap(prepareResult -> prepareResult.version, prepareResult -> prepareResult.fileDistributionProvider.getFileRegistry()));
        }

        public ConfigChangeActions getConfigChangeActions() {
            return new ConfigChangeActions(this.results.stream().map(result -> result.actions).flatMap(Collection::stream).collect(Collectors.toList()));
        }
    }

    private class Preparation {
        final DeployLogger logger;
        final PrepareParams params;
        final ApplicationId applicationId;
        final Optional<DockerImage> dockerImageRepository;
        final Version vespaVersion;
        final ContainerEndpointsCache containerEndpointsCache;
        final List<ContainerEndpoint> containerEndpoints;
        final ModelContext.Properties properties;
        private final EndpointCertificateMetadataStore endpointCertificateMetadataStore;
        private final Optional<EndpointCertificateMetadata> endpointCertificateMetadata;
        private final Optional<AthenzDomain> athenzDomain;
        private final ApplicationRolesStore applicationRolesStore;
        private final Optional<ApplicationRoles> applicationRoles;
        private final ApplicationPackage applicationPackage;
        private final SessionZooKeeperClient sessionZooKeeperClient;
        private ApplicationPackage preprocessedApplicationPackage;
        private List<PreparedModelsBuilder.PreparedModelResult> modelResultList;
        private PrepareResult prepareResult;
        private final PreparedModelsBuilder preparedModelsBuilder;
        private final FileDistributionProvider fileDistributionProvider;

        Preparation(HostValidator<ApplicationId> hostValidator, DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, Path tenantPath, File serverDbSessionDir, ApplicationPackage preprocessedApplicationPackage, SessionZooKeeperClient sessionZooKeeperClient) {
            this.logger = logger;
            this.params = params;
            this.applicationPackage = preprocessedApplicationPackage;
            this.sessionZooKeeperClient = sessionZooKeeperClient;
            this.applicationId = params.getApplicationId();
            this.dockerImageRepository = params.dockerImageRepository();
            this.vespaVersion = params.vespaVersion().orElse(Vtag.currentVersion);
            this.containerEndpointsCache = new ContainerEndpointsCache(tenantPath, SessionPreparer.this.curator);
            this.endpointCertificateMetadataStore = new EndpointCertificateMetadataStore(SessionPreparer.this.curator, tenantPath);
            EndpointCertificateRetriever endpointCertificateRetriever = new EndpointCertificateRetriever(SessionPreparer.this.secretStore);
            this.endpointCertificateMetadata = params.endpointCertificateMetadata().or(() -> params.tlsSecretsKeyName().map(EndpointCertificateMetadataSerializer::fromString));
            Optional<EndpointCertificateSecrets> endpointCertificateSecrets = this.endpointCertificateMetadata.or(() -> this.endpointCertificateMetadataStore.readEndpointCertificateMetadata(this.applicationId)).flatMap(endpointCertificateRetriever::readEndpointCertificateSecrets);
            this.containerEndpoints = this.readEndpointsIfNull(params.containerEndpoints());
            this.athenzDomain = params.athenzDomain();
            this.applicationRolesStore = new ApplicationRolesStore(SessionPreparer.this.curator, tenantPath);
            this.applicationRoles = params.applicationRoles().or(() -> this.applicationRolesStore.readApplicationRoles(this.applicationId));
            this.properties = new ModelContextImpl.Properties(params.getApplicationId(), SessionPreparer.this.configserverConfig, SessionPreparer.this.zone, Set.copyOf(this.containerEndpoints), params.isBootstrap(), currentActiveApplicationSet.isEmpty(), SessionPreparer.this.flagSource, endpointCertificateSecrets, this.athenzDomain, this.applicationRoles, params.quota());
            this.fileDistributionProvider = SessionPreparer.this.fileDistributionFactory.createProvider(serverDbSessionDir);
            this.preparedModelsBuilder = new PreparedModelsBuilder(SessionPreparer.this.modelFactoryRegistry, SessionPreparer.this.permanentApplicationPackage, SessionPreparer.this.configDefinitionRepo, this.fileDistributionProvider, SessionPreparer.this.hostProvisionerProvider, SessionPreparer.this.curator, hostValidator, logger, params, currentActiveApplicationSet, this.properties, SessionPreparer.this.configserverConfig);
        }

        void checkTimeout(String step) {
            TimeoutBudget timeoutBudget = this.params.getTimeoutBudget();
            if (!timeoutBudget.hasTimeLeft(step)) {
                String used = timeoutBudget.timesUsed();
                throw new UncheckedTimeoutException("prepare timed out " + used + " after " + step + " step (timeout " + timeoutBudget.timeout() + "): " + this.applicationId);
            }
        }

        Optional<FileReference> distributeApplicationPackage() {
            FileRegistry fileRegistry = this.fileDistributionProvider.getFileRegistry();
            FileReference fileReference = fileRegistry.addApplicationPackage();
            FileDistribution fileDistribution = this.fileDistributionProvider.getFileDistribution();
            log.log(Level.FINE, () -> "Distribute application package for " + this.applicationId + " (" + fileReference + ") to other config servers");
            this.properties.configServerSpecs().stream().filter(spec -> !spec.getHostName().equals(fileRegistry.fileSourceHost())).forEach(spec -> fileDistribution.startDownload(spec.getHostName(), spec.getConfigServerPort(), Set.of(fileReference)));
            this.checkTimeout("distributeApplicationPackage");
            return Optional.of(fileReference);
        }

        void preprocess() {
            try {
                this.preprocessedApplicationPackage = this.applicationPackage.preprocess(this.properties.zone(), this.logger);
            }
            catch (IOException | RuntimeException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new IllegalArgumentException("Error preprocessing application package for " + this.applicationId, e);
            }
            this.checkTimeout("preprocess");
        }

        AllocatedHosts buildModels(Instant now) {
            SettableOptional allocatedHosts = new SettableOptional();
            this.modelResultList = this.preparedModelsBuilder.buildModels(this.applicationId, this.dockerImageRepository, this.vespaVersion, this.preprocessedApplicationPackage, (SettableOptional<AllocatedHosts>)allocatedHosts, now);
            this.checkTimeout("build models");
            return (AllocatedHosts)allocatedHosts.get();
        }

        void makeResult(AllocatedHosts allocatedHosts) {
            this.prepareResult = new PrepareResult(allocatedHosts, this.modelResultList);
            this.checkTimeout("making result from models");
        }

        void writeStateZK(Optional<FileReference> distributedApplicationPackage) {
            log.log(Level.FINE, "Writing application package state to zookeeper");
            SessionPreparer.this.writeStateToZooKeeper(this.sessionZooKeeperClient, this.preprocessedApplicationPackage, this.applicationId, distributedApplicationPackage, this.dockerImageRepository, this.vespaVersion, this.logger, this.prepareResult.getFileRegistries(), this.prepareResult.allocatedHosts(), this.athenzDomain, this.params.quota());
            this.checkTimeout("write state to zookeeper");
        }

        void writeEndpointCertificateMetadataZK() {
            this.endpointCertificateMetadata.ifPresent(metadata -> this.endpointCertificateMetadataStore.writeEndpointCertificateMetadata(this.applicationId, (EndpointCertificateMetadata)metadata));
            this.checkTimeout("write endpoint certificate metadata to zookeeper");
        }

        void writeContainerEndpointsZK() {
            this.containerEndpointsCache.write(this.applicationId, this.containerEndpoints);
            this.checkTimeout("write container endpoints to zookeeper");
        }

        void writeApplicationRoles() {
            this.applicationRoles.ifPresent(roles -> this.applicationRolesStore.writeApplicationRoles(this.applicationId, (ApplicationRoles)roles));
            this.checkTimeout("write application roles to zookeeper");
        }

        void distribute() {
            this.prepareResult.asList().forEach(modelResult -> modelResult.model.distributeFiles(modelResult.fileDistributionProvider.getFileDistribution()));
            this.checkTimeout("distribute files");
        }

        PrepareResult result() {
            return this.prepareResult;
        }

        private List<ContainerEndpoint> readEndpointsIfNull(List<ContainerEndpoint> endpoints) {
            if (endpoints == null) {
                endpoints = this.containerEndpointsCache.read(this.applicationId);
            }
            return List.copyOf(endpoints);
        }
    }
}

