/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.JSONResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class ConfigConvergenceChecker
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(ConfigConvergenceChecker.class.getName());
    private static final Set<String> serviceTypesToCheck = Set.of(ContainerServiceType.CONTAINER.serviceName, ContainerServiceType.QRSERVER.serviceName, ContainerServiceType.LOGSERVER_CONTAINER.serviceName, ContainerServiceType.CLUSTERCONTROLLER_CONTAINER.serviceName, "searchnode", "storagenode", "distributor");
    private final CloseableHttpClient httpClient;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final ExecutorService executor = ConfigConvergenceChecker.createThreadpool();

    @Inject
    public ConfigConvergenceChecker() {
        this.httpClient = ConfigConvergenceChecker.createHttpClient();
    }

    public Map<ServiceInfo, Long> getServiceConfigGenerations(Application application, Duration timeoutPerService) {
        ArrayList<ServiceInfo> servicesToCheck = new ArrayList<ServiceInfo>();
        application.getModel().getHosts().forEach(host -> host.getServices().stream().filter(service -> serviceTypesToCheck.contains(service.getServiceType())).forEach(service -> ConfigConvergenceChecker.getStatePort(service).ifPresent(port -> servicesToCheck.add((ServiceInfo)service))));
        return this.getServiceGenerations(servicesToCheck, timeoutPerService);
    }

    public JSONResponse getServiceConfigGenerationsResponse(Application application, URI requestUrl, Duration timeoutPerService) {
        Map<ServiceInfo, Long> currentGenerations = this.getServiceConfigGenerations(application, timeoutPerService);
        long currentGeneration = currentGenerations.values().stream().mapToLong(Long::longValue).min().orElse(-1L);
        return new ServiceListResponse(200, currentGenerations, requestUrl, application.getApplicationGeneration(), currentGeneration);
    }

    public JSONResponse getServiceConfigGenerationResponse(Application application, String hostAndPortToCheck, URI requestUrl, Duration timeout) {
        Long wantedGeneration = application.getApplicationGeneration();
        try {
            if (!this.hostInApplication(application, hostAndPortToCheck)) {
                return ServiceResponse.createHostNotFoundInAppResponse(requestUrl, hostAndPortToCheck, wantedGeneration);
            }
            long currentGeneration = this.getServiceGeneration(URI.create("http://" + hostAndPortToCheck), timeout);
            boolean converged = currentGeneration >= wantedGeneration;
            return ServiceResponse.createOkResponse(requestUrl, hostAndPortToCheck, wantedGeneration, currentGeneration, converged);
        }
        catch (NonSuccessStatusCodeException | IOException e) {
            return ServiceResponse.createNotFoundResponse(requestUrl, hostAndPortToCheck, wantedGeneration, e.getMessage());
        }
        catch (Exception e) {
            return ServiceResponse.createErrorResponse(requestUrl, hostAndPortToCheck, wantedGeneration, e.getMessage());
        }
    }

    public void deconstruct() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Map<ServiceInfo, Long> getServiceGenerations(List<ServiceInfo> services, Duration timeout) {
        List tasks = services.stream().map(service -> () -> {
            long generation;
            try {
                generation = this.getServiceGeneration(URI.create("http://" + service.getHostName() + ":" + ConfigConvergenceChecker.getStatePort(service).get()), timeout);
            }
            catch (NonSuccessStatusCodeException | IOException e) {
                generation = -1L;
            }
            return new ServiceInfoWithGeneration((ServiceInfo)service, generation);
        }).collect(Collectors.toList());
        try {
            List taskResults = this.executor.invokeAll(tasks);
            LinkedHashMap<ServiceInfo, Long> result = new LinkedHashMap<ServiceInfo, Long>();
            for (Future taskResult : taskResults) {
                ServiceInfoWithGeneration info = (ServiceInfoWithGeneration)taskResult.get();
                result.put(info.service, info.generation);
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Failed to retrieve config generation: " + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve config generation: " + e.getMessage(), e);
        }
    }

    private long getServiceGeneration(URI serviceUrl, Duration timeout) throws IOException, NonSuccessStatusCodeException {
        long l;
        block10: {
            HttpGet request = new HttpGet(ConfigConvergenceChecker.createApiUri(serviceUrl));
            request.addHeader("Connection", "close");
            request.setConfig(ConfigConvergenceChecker.createRequestConfig(timeout));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new NonSuccessStatusCodeException(statusCode);
                }
                if (response.getEntity() == null) {
                    throw new IOException("Response has no content");
                }
                JsonNode jsonContent = this.jsonMapper.readTree(response.getEntity().getContent());
                l = ConfigConvergenceChecker.generationFromContainerState(jsonContent);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.log((Level)LogLevel.DEBUG, e, () -> String.format("Failed to retrieve service config generation for '%s': %s", serviceUrl, e.getMessage()));
                    throw e;
                }
            }
            response.close();
        }
        return l;
    }

    private boolean hostInApplication(Application application, String hostPort) {
        for (HostInfo host : application.getModel().getHosts()) {
            if (!hostPort.startsWith(host.getHostname())) continue;
            for (ServiceInfo service : host.getServices()) {
                for (PortInfo port : service.getPorts()) {
                    if (!hostPort.equals(host.getHostname() + ":" + port.getPort())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Optional<Integer> getStatePort(ServiceInfo service) {
        return service.getPorts().stream().filter(port -> port.getTags().contains("state")).map(PortInfo::getPort).findFirst();
    }

    private static long generationFromContainerState(JsonNode state) {
        return state.get("config").get("generation").asLong(-1L);
    }

    private static URI createApiUri(URI serviceUrl) {
        try {
            return new URIBuilder(serviceUrl).setPath("/state/v1/config").build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static ExecutorService createThreadpool() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new DaemonThreadFactory("config-convergence-checker-"));
    }

    private static CloseableHttpClient createHttpClient() {
        return VespaHttpClientBuilder.create().setUserAgent("config-convergence-checker").setMaxConnPerRoute(10).setMaxConnTotal(400).setConnectionReuseStrategy((response, context) -> false).build();
    }

    private static RequestConfig createRequestConfig(Duration timeout) {
        int timeoutMillis = (int)timeout.toMillis();
        return RequestConfig.custom().setConnectionRequestTimeout(timeoutMillis).setConnectTimeout(timeoutMillis).setSocketTimeout(timeoutMillis).build();
    }

    private static class ServiceResponse
    extends JSONResponse {
        private ServiceResponse(int status, URI uri, String hostname, Long wantedGeneration) {
            super(status);
            this.object.setString("url", uri.toString());
            this.object.setString("host", hostname);
            this.object.setLong("wantedGeneration", wantedGeneration.longValue());
        }

        static ServiceResponse createOkResponse(URI uri, String hostname, Long wantedGeneration, Long currentGeneration, boolean converged) {
            ServiceResponse serviceResponse = new ServiceResponse(200, uri, hostname, wantedGeneration);
            serviceResponse.object.setBool("converged", converged);
            serviceResponse.object.setLong("currentGeneration", currentGeneration.longValue());
            return serviceResponse;
        }

        static ServiceResponse createHostNotFoundInAppResponse(URI uri, String hostname, Long wantedGeneration) {
            ServiceResponse serviceResponse = new ServiceResponse(410, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("problem", "Host:port (service) no longer part of application, refetch list of services.");
            return serviceResponse;
        }

        static ServiceResponse createErrorResponse(URI uri, String hostname, Long wantedGeneration, String error) {
            ServiceResponse serviceResponse = new ServiceResponse(500, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("error", error);
            return serviceResponse;
        }

        static ServiceResponse createNotFoundResponse(URI uri, String hostname, Long wantedGeneration, String error) {
            ServiceResponse serviceResponse = new ServiceResponse(404, uri, hostname, wantedGeneration);
            serviceResponse.object.setString("error", error);
            return serviceResponse;
        }
    }

    private static class ServiceListResponse
    extends JSONResponse {
        private ServiceListResponse(int status, Map<ServiceInfo, Long> servicesToCheck, URI uri, long wantedGeneration, long currentGeneration) {
            super(status);
            Cursor serviceArray = this.object.setArray("services");
            servicesToCheck.forEach((service, generation) -> {
                Cursor serviceObject = serviceArray.addObject();
                String hostName = service.getHostName();
                int statePort = ConfigConvergenceChecker.getStatePort(service).get();
                serviceObject.setString("host", hostName);
                serviceObject.setLong("port", (long)statePort);
                serviceObject.setString("type", service.getServiceType());
                serviceObject.setString("url", uri.toString() + "/" + hostName + ":" + statePort);
                serviceObject.setLong("currentGeneration", generation.longValue());
            });
            this.object.setString("url", uri.toString());
            this.object.setLong("currentGeneration", currentGeneration);
            this.object.setLong("wantedGeneration", wantedGeneration);
            this.object.setBool("converged", currentGeneration >= wantedGeneration);
        }
    }

    private static class NonSuccessStatusCodeException
    extends Exception {
        final int statusCode;

        NonSuccessStatusCodeException(int statusCode) {
            super("Expected status code 200, got " + statusCode);
            this.statusCode = statusCode;
        }
    }

    private static class ServiceInfoWithGeneration {
        final ServiceInfo service;
        final long generation;

        ServiceInfoWithGeneration(ServiceInfo service, long generation) {
            this.service = service;
            this.generation = generation;
        }
    }
}

