/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.configchange;

import com.yahoo.vespa.config.server.configchange.ReindexActions;

class ReindexActionsFormatter {
    private final ReindexActions actions;

    ReindexActionsFormatter(ReindexActions actions) {
        this.actions = actions;
    }

    String format() {
        StringBuilder builder = new StringBuilder();
        for (ReindexActions.Entry entry : this.actions.getEntries()) {
            if (entry.allowed()) {
                builder.append("(allowed) ");
            }
            builder.append(entry.name() + ": Consider re-indexing document type '" + entry.getDocumentType() + "' in cluster '" + entry.getClusterName() + "' because:\n");
            int counter = 1;
            for (String message : entry.getMessages()) {
                builder.append("    " + counter++ + ") " + message + "\n");
            }
        }
        return builder.toString();
    }
}

