/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import java.util.Objects;
import java.util.Optional;

public class RemoteSession
extends Session {
    private final Optional<ApplicationSet> applicationSet;

    RemoteSession(TenantName tenant, long sessionId, SessionZooKeeperClient zooKeeperClient) {
        this(tenant, sessionId, zooKeeperClient, Optional.empty());
    }

    RemoteSession(TenantName tenant, long sessionId, SessionZooKeeperClient zooKeeperClient, Optional<ApplicationSet> applicationSet) {
        super(tenant, sessionId, zooKeeperClient);
        this.applicationSet = applicationSet;
    }

    Optional<ApplicationSet> applicationSet() {
        return this.applicationSet;
    }

    public synchronized RemoteSession activated(ApplicationSet applicationSet) {
        Objects.requireNonNull(applicationSet, "applicationSet cannot be null");
        return new RemoteSession(this.tenant, this.sessionId, this.sessionZooKeeperClient, Optional.of(applicationSet));
    }

    public synchronized RemoteSession deactivated() {
        return new RemoteSession(this.tenant, this.sessionId, this.sessionZooKeeperClient, Optional.empty());
    }

    @Override
    public String toString() {
        return super.toString() + ",application set=" + this.applicationSet;
    }
}

