/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.zookeeper.data.Stat;

public class LocksMaintainer
extends ConfigServerMaintainer {
    private final boolean hostedVespa;
    private final Curator curator;

    LocksMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, flagSource, Duration.ZERO, interval);
        this.hostedVespa = applicationRepository.configserverConfig().hostedVespa();
        this.curator = curator;
    }

    protected boolean maintain() {
        if (!this.hostedVespa) {
            return true;
        }
        Path unallocatedLockPath = Path.fromString((String)"/provision/v1/locks/unallocatedLock");
        this.logLockInfo(unallocatedLockPath);
        this.applicationRepository.listApplications().forEach(applicationId -> {
            Path applicationLockPath = Path.fromString((String)"/provision/v1/locks").append(applicationId.tenant().value()).append(applicationId.application().value()).append(applicationId.instance().value());
            this.logLockInfo(applicationLockPath);
        });
        return true;
    }

    private void logLockInfo(Path path) {
        List children = this.curator.getChildren(path);
        if (children.size() > 0) {
            this.log.log(Level.FINE, path + " has " + children.size() + " locks ");
        }
        children.forEach(lockString -> {
            Optional<Instant> createTime = Optional.empty();
            Path lockPath = path.append(lockString);
            Optional stat = this.curator.getStat(lockPath);
            if (stat.isPresent()) {
                createTime = Optional.of(Instant.ofEpochMilli(((Stat)stat.get()).getCtime()));
            }
            this.log.log(Level.FINE, "Lock /" + lockPath + " created " + createTime.map(Instant::toString).orElse(" at unknown time"));
        });
    }
}

