/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpConfigRequest;
import com.yahoo.vespa.config.server.http.HttpConfigResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Optional;
import java.util.logging.Level;

public class HttpGetConfigHandler
extends HttpHandler {
    private final RequestHandler requestHandler;

    public HttpGetConfigHandler(LoggingRequestHandler.Context ctx, RequestHandler requestHandler) {
        super(ctx);
        this.requestHandler = requestHandler;
    }

    @Inject
    public HttpGetConfigHandler(LoggingRequestHandler.Context ctx, TenantRepository tenantRepository) {
        this(ctx, tenantRepository.defaultTenant().getRequestHandler());
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        HttpConfigRequest request = HttpConfigRequest.createFromRequestV1(req);
        HttpConfigRequest.validateRequestKey(request.getConfigKey(), this.requestHandler, ApplicationId.defaultId());
        return HttpConfigResponse.createFromConfig(this.resolveConfig(request));
    }

    private ConfigResponse resolveConfig(HttpConfigRequest request) {
        this.log.log(Level.FINE, "nocache=" + request.noCache());
        ConfigResponse config = this.requestHandler.resolveConfig(ApplicationId.defaultId(), request, Optional.empty());
        if (config == null) {
            HttpConfigRequest.throwModelNotReady();
        }
        return config;
    }
}

