/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.DoubleFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.IntFlag;
import com.yahoo.vespa.flags.StringFlag;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final Optional<HostProvisioner> hostProvisioner;
    private final Provisioned provisioned;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, Optional<ApplicationPackage> permanentApplicationPackage, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, Optional<HostProvisioner> hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public Optional<ApplicationPackage> permanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public Optional<HostProvisioner> hostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final boolean useContentNodeBtreeDb;
        private final boolean useThreePhaseUpdates;
        private final boolean useDirectStorageApiRpc;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final double defaultTermwiseLimit;
        private final double threadPoolSizeFactor;
        private final double queueSizefactor;
        private final String jvmGCOPtions;
        private final String feedSequencer;
        private final String responseSequencer;
        private final int numResponseThreads;
        private final boolean skipCommunicationManagerThread;
        private final boolean skipMbusRequestThread;
        private final boolean skipMbusReplyThread;
        private final Optional<AthenzDomain> athenzDomain;
        private final Optional<ApplicationRoles> applicationRoles;
        private final double feedCoreThreadPoolSizeFactor;
        private final double visibilityDelay;
        private final Quota quota;
        private final boolean tlsUseFSync;
        private final String tlsCompressionType;

        public Properties(ApplicationId applicationId, boolean multitenantFromConfig, List<ConfigServerSpec> configServerSpecs, HostName loadBalancerName, URI ztsUrl, String athenzDnsSuffix, boolean hostedVespa, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain, Optional<ApplicationRoles> applicationRoles, Optional<Quota> maybeQuota) {
            this.applicationId = applicationId;
            this.multitenant = multitenantFromConfig || hostedVespa || Boolean.getBoolean("multitenant");
            this.configServerSpecs = configServerSpecs;
            this.loadBalancerName = loadBalancerName;
            this.ztsUrl = ztsUrl;
            this.athenzDnsSuffix = athenzDnsSuffix;
            this.hostedVespa = hostedVespa;
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.defaultTermwiseLimit = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_TERM_WISE_LIMIT.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useContentNodeBtreeDb = ((BooleanFlag)((BooleanFlag)Flags.USE_CONTENT_NODE_BTREE_DB.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useThreePhaseUpdates = ((BooleanFlag)((BooleanFlag)Flags.USE_THREE_PHASE_UPDATES.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.useDirectStorageApiRpc = ((BooleanFlag)((BooleanFlag)Flags.USE_DIRECT_STORAGE_API_RPC.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.threadPoolSizeFactor = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_THREADPOOL_SIZE_FACTOR.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.visibilityDelay = ((DoubleFlag)((DoubleFlag)Flags.VISIBILITY_DELAY.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.tlsCompressionType = ((StringFlag)((StringFlag)Flags.TLS_COMPRESSION_TYPE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.tlsUseFSync = ((BooleanFlag)((BooleanFlag)Flags.TLS_USE_FSYNC.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.queueSizefactor = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_QUEUE_SIZE_FACTOR.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.jvmGCOPtions = ((StringFlag)((StringFlag)Flags.JVM_GC_OPTIONS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.feedSequencer = ((StringFlag)((StringFlag)Flags.FEED_SEQUENCER_TYPE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.responseSequencer = ((StringFlag)((StringFlag)Flags.RESPONSE_SEQUENCER_TYPE.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.numResponseThreads = ((IntFlag)((IntFlag)Flags.RESPONSE_NUM_THREADS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.skipCommunicationManagerThread = ((BooleanFlag)((BooleanFlag)Flags.SKIP_COMMUNICATIONMANAGER_THREAD.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.skipMbusRequestThread = ((BooleanFlag)((BooleanFlag)Flags.SKIP_MBUS_REQUEST_THREAD.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.skipMbusReplyThread = ((BooleanFlag)((BooleanFlag)Flags.SKIP_MBUS_REPLY_THREAD.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.athenzDomain = athenzDomain;
            this.applicationRoles = applicationRoles;
            this.feedCoreThreadPoolSizeFactor = ((DoubleFlag)((DoubleFlag)Flags.FEED_CORE_THREAD_POOL_SIZE_FACTOR.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.quota = maybeQuota.orElseGet(Quota::empty);
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public double defaultTermwiseLimit() {
            return this.defaultTermwiseLimit;
        }

        public double threadPoolSizeFactor() {
            return this.threadPoolSizeFactor;
        }

        public double queueSizeFactor() {
            return this.queueSizefactor;
        }

        public boolean useContentNodeBtreeDb() {
            return this.useContentNodeBtreeDb;
        }

        public boolean useThreePhaseUpdates() {
            return this.useThreePhaseUpdates;
        }

        public boolean useDirectStorageApiRpc() {
            return this.useDirectStorageApiRpc;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }

        public Optional<ApplicationRoles> applicationRoles() {
            return this.applicationRoles;
        }

        public String jvmGCOptions() {
            return this.jvmGCOPtions;
        }

        public String feedSequencerType() {
            return this.feedSequencer;
        }

        public String responseSequencerType() {
            return this.responseSequencer;
        }

        public int defaultNumResponseThreads() {
            return this.numResponseThreads;
        }

        public boolean skipCommunicationManagerThread() {
            return this.skipCommunicationManagerThread;
        }

        public boolean skipMbusRequestThread() {
            return this.skipMbusRequestThread;
        }

        public boolean skipMbusReplyThread() {
            return this.skipMbusReplyThread;
        }

        public double feedCoreThreadPoolSizeFactor() {
            return this.feedCoreThreadPoolSizeFactor;
        }

        public double visibilityDelay() {
            return this.visibilityDelay;
        }

        public boolean tlsUseFSync() {
            return this.tlsUseFSync;
        }

        public String tlsCompressionType() {
            return this.tlsCompressionType;
        }

        public Quota quota() {
            return this.quota;
        }
    }
}

