/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.concurrent.StripedExecutor;
import com.yahoo.config.FileReference;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.text.Utf8;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.GetConfigRequest;
import com.yahoo.vespa.config.protocol.ConfigResponse;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.ReloadListener;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationMapper;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.VersionDoesNotExistException;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.host.HostRegistry;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.monitoring.Metrics;
import com.yahoo.vespa.config.server.rpc.ConfigResponseFactory;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;

public class TenantApplications
implements RequestHandler,
HostValidator<ApplicationId> {
    private static final Logger log = Logger.getLogger(TenantApplications.class.getName());
    private final Curator curator;
    private final Path applicationsPath;
    private final Path locksPath;
    private final Curator.DirectoryCache directoryCache;
    private final Executor zkWatcherExecutor;
    private final Metrics metrics;
    private final TenantName tenant;
    private final ReloadListener reloadListener;
    private final ConfigResponseFactory responseFactory;
    private final HostRegistry<ApplicationId> hostRegistry;
    private final ApplicationMapper applicationMapper = new ApplicationMapper();
    private final MetricUpdater tenantMetricUpdater;
    private final Clock clock = Clock.systemUTC();
    private final TenantFileSystemDirs tenantFileSystemDirs;

    public TenantApplications(TenantName tenant, Curator curator, StripedExecutor<TenantName> zkWatcherExecutor, ExecutorService zkCacheExecutor, Metrics metrics, ReloadListener reloadListener, ConfigserverConfig configserverConfig, HostRegistry<ApplicationId> hostRegistry, TenantFileSystemDirs tenantFileSystemDirs) {
        this.curator = curator;
        this.applicationsPath = TenantRepository.getApplicationsPath(tenant);
        this.locksPath = TenantRepository.getLocksPath(tenant);
        this.tenant = tenant;
        this.zkWatcherExecutor = command -> zkWatcherExecutor.execute((Object)tenant, command);
        this.directoryCache = curator.createDirectoryCache(this.applicationsPath.getAbsolute(), false, false, zkCacheExecutor);
        this.directoryCache.addListener(this::childEvent);
        this.directoryCache.start();
        this.metrics = metrics;
        this.reloadListener = reloadListener;
        this.responseFactory = ConfigResponseFactory.create(configserverConfig);
        this.tenantMetricUpdater = metrics.getOrCreateMetricUpdater(Metrics.createDimensions(tenant));
        this.hostRegistry = hostRegistry;
        this.tenantFileSystemDirs = tenantFileSystemDirs;
    }

    public static TenantApplications create(GlobalComponentRegistry componentRegistry, TenantName tenantName) {
        return new TenantApplications(tenantName, componentRegistry.getCurator(), componentRegistry.getZkWatcherExecutor(), componentRegistry.getZkCacheExecutor(), componentRegistry.getMetrics(), componentRegistry.getReloadListener(), componentRegistry.getConfigserverConfig(), componentRegistry.getHostRegistries().createApplicationHostRegistry(tenantName), new TenantFileSystemDirs(componentRegistry.getConfigServerDB(), tenantName));
    }

    public List<ApplicationId> activeApplications() {
        return this.curator.getChildren(this.applicationsPath).stream().sorted().map(ApplicationId::fromSerializedForm).filter(id -> this.activeSessionOf((ApplicationId)id).isPresent()).collect(Collectors.toUnmodifiableList());
    }

    public boolean exists(ApplicationId id) {
        return this.curator.exists(this.applicationPath(id));
    }

    public Optional<Long> activeSessionOf(ApplicationId id) {
        Optional data = this.curator.getData(this.applicationPath(id));
        return data.isEmpty() || ((byte[])data.get()).length == 0 ? Optional.empty() : data.map(bytes -> Long.parseLong(Utf8.toString((byte[])bytes)));
    }

    public boolean hasLocalSession(long sessionId) {
        return Files.exists(Paths.get(this.tenantFileSystemDirs.sessionsPath().getAbsolutePath(), String.valueOf(sessionId)), new LinkOption[0]);
    }

    public Transaction createPutTransaction(ApplicationId applicationId, long sessionId) {
        return new CuratorTransaction(this.curator).add((Transaction.Operation)CuratorOperations.setData((String)this.applicationPath(applicationId).getAbsolute(), (byte[])Utf8.toAsciiBytes((long)sessionId)));
    }

    public void createApplication(ApplicationId id) {
        if (!id.tenant().equals((Object)this.tenant)) {
            throw new IllegalArgumentException("Cannot write application id '" + id + "' for tenant '" + this.tenant + "'");
        }
        try (Lock lock = this.lock(id);){
            this.curator.create(this.applicationPath(id));
        }
    }

    public long requireActiveSessionOf(ApplicationId applicationId) {
        return this.activeSessionOf(applicationId).orElseThrow(() -> new IllegalArgumentException("Application '" + applicationId + "' has no active session."));
    }

    public CuratorTransaction createDeleteTransaction(ApplicationId applicationId) {
        return CuratorTransaction.from((List)CuratorOperations.deleteAll((String)this.applicationPath(applicationId).getAbsolute(), (Curator)this.curator), (Curator)this.curator);
    }

    public void removeUnusedApplications() {
        this.removeApplicationsExcept(Set.copyOf(this.activeApplications()));
    }

    public void close() {
        this.directoryCache.close();
    }

    public Lock lock(ApplicationId id) {
        return this.curator.lock(this.lockPath(id), Duration.ofMinutes(1L));
    }

    private void childEvent(CuratorFramework ignored, PathChildrenCacheEvent event) {
        this.zkWatcherExecutor.execute(() -> {
            switch (event.getType()) {
                case CHILD_ADDED: {
                    this.applicationAdded(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                    break;
                }
                case CHILD_REMOVED: {
                    this.applicationRemoved(ApplicationId.fromSerializedForm((String)Path.fromString((String)event.getData().getPath()).getName()));
                    break;
                }
                case CHILD_UPDATED: {
                    break;
                }
            }
            this.removeUnusedApplications();
        });
    }

    private void applicationRemoved(ApplicationId applicationId) {
        this.removeApplication(applicationId);
        log.log(Level.INFO, TenantRepository.logPre(applicationId) + "Application removed: " + applicationId);
    }

    private void applicationAdded(ApplicationId applicationId) {
        log.log(Level.FINE, TenantRepository.logPre(applicationId) + "Application added: " + applicationId);
    }

    private Path applicationPath(ApplicationId id) {
        return this.applicationsPath.append(id.serializedForm());
    }

    private Path lockPath(ApplicationId id) {
        return this.locksPath.append(id.serializedForm());
    }

    @Override
    public ConfigResponse resolveConfig(ApplicationId appId, GetConfigRequest req, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, TenantRepository.logPre(appId) + "Resolving for tenant '" + this.tenant + "' with handler for application '" + application + "'");
        }
        return application.resolveConfig(req, this.responseFactory);
    }

    private void notifyReloadListeners(ApplicationSet applicationSet) {
        this.reloadListener.hostsUpdated(this.tenant, this.hostRegistry.getAllHosts());
        this.reloadListener.configActivated(applicationSet);
    }

    public void reloadConfig(ApplicationSet applicationSet) {
        ApplicationId id = applicationSet.getId();
        try (Lock lock = this.lock(id);){
            if (!this.exists(id)) {
                return;
            }
            if (applicationSet.getApplicationGeneration() != this.requireActiveSessionOf(id)) {
                return;
            }
            this.setLiveApp(applicationSet);
            this.notifyReloadListeners(applicationSet);
        }
    }

    public void removeApplication(ApplicationId applicationId) {
        try (Lock lock = this.lock(applicationId);){
            if (this.exists(applicationId)) {
                return;
            }
            if (this.applicationMapper.hasApplication(applicationId, this.clock.instant())) {
                this.applicationMapper.remove(applicationId);
                this.hostRegistry.removeHostsForKey(applicationId);
                this.reloadListenersOnRemove(applicationId);
                this.tenantMetricUpdater.setApplications(this.applicationMapper.numApplications());
                this.metrics.removeMetricUpdater(Metrics.createDimensions(applicationId));
            }
        }
    }

    public void removeApplicationsExcept(Set<ApplicationId> applications) {
        for (ApplicationId activeApplication : this.applicationMapper.listApplicationIds()) {
            if (applications.contains(activeApplication)) continue;
            log.log(Level.INFO, "Will remove deleted application " + activeApplication.toShortString());
            this.removeApplication(activeApplication);
        }
    }

    private void reloadListenersOnRemove(ApplicationId applicationId) {
        this.reloadListener.hostsUpdated(this.tenant, this.hostRegistry.getAllHosts());
        this.reloadListener.applicationRemoved(applicationId);
    }

    private void setLiveApp(ApplicationSet applicationSet) {
        ApplicationId id = applicationSet.getId();
        Collection<String> hostsForApp = applicationSet.getAllHosts();
        this.hostRegistry.update(id, hostsForApp);
        applicationSet.updateHostMetrics();
        this.tenantMetricUpdater.setApplications(this.applicationMapper.numApplications());
        this.applicationMapper.register(id, applicationSet);
    }

    @Override
    public Set<ConfigKey<?>> listNamedConfigs(ApplicationId appId, Optional<Version> vespaVersion, ConfigKey<?> keyToMatch, boolean recursive) {
        Application application = this.getApplication(appId, vespaVersion);
        return this.listConfigs(application, keyToMatch, recursive);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ConfigKey<?>> listConfigs(Application application, ConfigKey<?> keyToMatch, boolean recursive) {
        LinkedHashSet ret = new LinkedHashSet();
        for (ConfigKey<?> configKey : application.allConfigsProduced()) {
            void var6_10;
            String configId = configKey.getConfigId();
            if (recursive) {
                ConfigKey configKey2 = new ConfigKey(configKey.getName(), configId, configKey.getNamespace());
            } else {
                ConfigKey configKey3 = new ConfigKey(configKey.getName(), configId.split("/")[0], configKey.getNamespace());
            }
            if (keyToMatch != null) {
                void var6_6;
                String n = var6_10.getName();
                String ns = var6_10.getNamespace();
                if (!n.equals(keyToMatch.getName()) || !ns.equals(keyToMatch.getNamespace()) || !configId.startsWith(keyToMatch.getConfigId()) || configId.equals(keyToMatch.getConfigId())) continue;
                if (!recursive) {
                    ConfigKey configKey4 = new ConfigKey(var6_10.getName(), this.appendOneLevelOfId(keyToMatch.getConfigId(), configId), var6_10.getNamespace());
                }
                ret.add((ConfigKey<?>)var6_6);
                continue;
            }
            ret.add((ConfigKey<?>)var6_10);
        }
        return ret;
    }

    @Override
    public Set<ConfigKey<?>> listConfigs(ApplicationId appId, Optional<Version> vespaVersion, boolean recursive) {
        Application application = this.getApplication(appId, vespaVersion);
        return this.listConfigs(application, null, recursive);
    }

    String appendOneLevelOfId(String baseIdSegment, String id) {
        if ("".equals(baseIdSegment)) {
            return id.split("/")[0];
        }
        String theRest = id.substring(baseIdSegment.length());
        if ("".equals(theRest)) {
            return id;
        }
        theRest = theRest.replaceFirst("/", "");
        String theRestFirstSeg = theRest.split("/")[0];
        return baseIdSegment + "/" + theRestFirstSeg;
    }

    @Override
    public Set<ConfigKey<?>> allConfigsProduced(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.allConfigsProduced();
    }

    private Application getApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        try {
            return this.applicationMapper.getForVersion(appId, vespaVersion, this.clock.instant());
        }
        catch (VersionDoesNotExistException ex) {
            throw new NotFoundException(String.format("%sNo such application (id %s): %s", TenantRepository.logPre(this.tenant), appId, ex.getMessage()));
        }
    }

    @Override
    public Set<String> allConfigIds(ApplicationId appId, Optional<Version> vespaVersion) {
        Application application = this.getApplication(appId, vespaVersion);
        return application.allConfigIds();
    }

    @Override
    public boolean hasApplication(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.hasHandler(appId, vespaVersion);
    }

    private boolean hasHandler(ApplicationId appId, Optional<Version> vespaVersion) {
        return this.applicationMapper.hasApplicationForVersion(appId, vespaVersion, this.clock.instant());
    }

    @Override
    public ApplicationId resolveApplicationId(String hostName) {
        return this.hostRegistry.getKeyForHost(hostName);
    }

    @Override
    public Set<FileReference> listFileReferences(ApplicationId applicationId) {
        return this.applicationMapper.listApplications(applicationId).stream().flatMap(app -> app.getModel().fileReferences().stream()).collect(Collectors.toSet());
    }

    @Override
    public void verifyHosts(ApplicationId key, Collection<String> newHosts) {
        this.hostRegistry.verifyHosts(key, newHosts);
        this.reloadListener.verifyHostsAreAvailable(this.tenant, newHosts);
    }

    public HostValidator<ApplicationId> getHostValidator() {
        return this;
    }

    public ApplicationId getApplicationIdForHostName(String hostname) {
        return this.hostRegistry.getKeyForHost(hostname);
    }

    public TenantFileSystemDirs getTenantFileSystemDirs() {
        return this.tenantFileSystemDirs;
    }
}

