/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import ai.vespa.util.http.VespaHttpClientBuilder;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.metrics.MetricsSlime;
import com.yahoo.vespa.config.server.metrics.ProtonMetricsAggregator;
import com.yahoo.yolean.Exceptions;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ClusterProtonMetricsRetriever {
    private static final Logger log = Logger.getLogger(ClusterProtonMetricsRetriever.class.getName());
    private static final CloseableHttpClient httpClient = VespaHttpClientBuilder.create(PoolingHttpClientConnectionManager::new).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(10000).build()).build();

    public Map<String, ProtonMetricsAggregator> requestMetricsGroupedByCluster(Collection<URI> hosts) {
        ConcurrentHashMap<String, ProtonMetricsAggregator> clusterMetricsMap = new ConcurrentHashMap<String, ProtonMetricsAggregator>();
        for (URI uri : hosts) {
            ClusterProtonMetricsRetriever.addMetricsFromHost(uri, clusterMetricsMap);
        }
        return clusterMetricsMap;
    }

    private static void addMetricsFromHost(URI hostURI, Map<String, ProtonMetricsAggregator> clusterMetricsMap) {
        Slime hostResponseBody;
        try {
            hostResponseBody = MetricsSlime.doMetricsRequest(hostURI, httpClient);
        }
        catch (IOException e) {
            log.info("Was unable to fetch metrics from " + hostURI + " : " + Exceptions.toMessageString((Throwable)e));
            hostResponseBody = new Slime();
        }
        Cursor parseError = hostResponseBody.get().field("error_message");
        if (parseError.valid()) {
            log.info("Failed to retrieve metrics from " + hostURI + ": " + parseError.asString());
        }
        Cursor nodes = hostResponseBody.get().field("nodes");
        nodes.traverse((i, nodesInspector) -> ClusterProtonMetricsRetriever.parseNode(nodesInspector, clusterMetricsMap));
    }

    private static void parseNode(Inspector node, Map<String, ProtonMetricsAggregator> clusterMetricsMap) {
        String nodeRole = node.field("role").asString();
        if (nodeRole.contains("content")) {
            ProtonMetricsAggregator aggregator = new ProtonMetricsAggregator();
            clusterMetricsMap.put(nodeRole, aggregator);
            node.field("services").traverse((i, servicesInspector) -> ClusterProtonMetricsRetriever.addServicesToAggregator(servicesInspector, aggregator));
        }
    }

    private static void addServicesToAggregator(Inspector services, ProtonMetricsAggregator aggregator) {
        services.field("metrics").traverse((i, metricsInspector) -> ClusterProtonMetricsRetriever.addMetricsToAggregator(metricsInspector, aggregator));
    }

    private static void addMetricsToAggregator(Inspector metrics, ProtonMetricsAggregator aggregator) {
        aggregator.addAll(metrics.field("values"));
    }
}

