/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.Metric;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ApplicationPackageMaintainer;
import com.yahoo.vespa.config.server.maintenance.FileDistributionMaintainer;
import com.yahoo.vespa.config.server.maintenance.SessionsMaintainer;
import com.yahoo.vespa.config.server.maintenance.TenantsMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Clock;
import java.time.Duration;

public class ConfigServerMaintenance
extends AbstractComponent {
    private final TenantsMaintainer tenantsMaintainer;
    private final FileDistributionMaintainer fileDistributionMaintainer;
    private final SessionsMaintainer sessionsMaintainer;
    private final ApplicationPackageMaintainer applicationPackageMaintainer;

    @Inject
    public ConfigServerMaintenance(ConfigserverConfig configserverConfig, ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, Metric metric) {
        DefaultTimes defaults = new DefaultTimes(configserverConfig);
        this.tenantsMaintainer = new TenantsMaintainer(applicationRepository, curator, flagSource, defaults.defaultInterval, Clock.systemUTC());
        this.fileDistributionMaintainer = new FileDistributionMaintainer(applicationRepository, curator, defaults.defaultInterval, flagSource);
        this.sessionsMaintainer = new SessionsMaintainer(applicationRepository, curator, Duration.ofSeconds(30L), flagSource);
        this.applicationPackageMaintainer = new ApplicationPackageMaintainer(applicationRepository, curator, Duration.ofSeconds(30L), flagSource);
    }

    public void deconstruct() {
        this.fileDistributionMaintainer.close();
        this.sessionsMaintainer.close();
        this.applicationPackageMaintainer.close();
        this.tenantsMaintainer.close();
    }

    public void runBeforeBootstrap() {
        this.fileDistributionMaintainer.lockAndMaintain();
        this.sessionsMaintainer.lockAndMaintain();
    }

    private static class DefaultTimes {
        private final Duration defaultInterval;

        DefaultTimes(ConfigserverConfig configserverConfig) {
            this.defaultInterval = Duration.ofMinutes(configserverConfig.maintainerIntervalMinutes());
        }
    }
}

