/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.Lock;
import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private final LocalSession session;
    private final ApplicationRepository applicationRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Tenant tenant;
    private final Duration timeout;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    final Optional<DockerImage> dockerImageRepository;
    private final Version version;
    private final boolean isBootstrap;
    private final Optional<AthenzDomain> athenzDomain;
    private boolean prepared = false;
    private final boolean validate;
    private boolean ignoreSessionStaleFailure = false;

    private Deployment(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean prepared, boolean validate, boolean isBootstrap) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.hostProvisioner = hostProvisioner;
        this.tenant = tenant;
        this.timeout = timeout;
        this.clock = clock;
        this.prepared = prepared;
        this.validate = validate;
        this.dockerImageRepository = session.getDockerImageRepository();
        this.version = session.getVespaVersion();
        this.isBootstrap = isBootstrap;
        this.athenzDomain = session.getAthenzDomain();
    }

    public static Deployment unprepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean validate, boolean isBootstrap) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, false, validate, isBootstrap);
    }

    public static Deployment prepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean isBootstrap) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, true, true, isBootstrap);
    }

    public void setIgnoreSessionStaleFailure(boolean ignoreSessionStaleFailure) {
        this.ignoreSessionStaleFailure = ignoreSessionStaleFailure;
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        ApplicationId applicationId = this.session.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.prepareMillis");){
            TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
            PrepareParams.Builder params = new PrepareParams.Builder().applicationId(applicationId).timeoutBudget(timeoutBudget).ignoreValidationErrors(!this.validate).vespaVersion(this.version.toString()).isBootstrap(this.isBootstrap);
            this.dockerImageRepository.ifPresent(params::dockerImageRepository);
            this.athenzDomain.ifPresent(params::athenzDomain);
            Optional<ApplicationSet> activeApplicationSet = this.applicationRepository.getCurrentActiveApplicationSet(this.tenant, applicationId);
            this.tenant.getSessionRepository().prepareLocalSession(this.session, this.logger, params.build(), activeApplicationSet, this.tenant.getPath(), this.clock.instant());
            this.prepared = true;
        }
    }

    public void activate() {
        if (!this.prepared) {
            this.prepare();
        }
        this.validateSessionStatus(this.session);
        ApplicationId applicationId = this.session.getApplicationId();
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(applicationId, "deployment.activateMillis");){
            Curator.CompletionWaiter waiter;
            RemoteSession previousActiveSession;
            TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
            if (!timeoutBudget.hasTimeLeft()) {
                throw new RuntimeException("Timeout exceeded when trying to activate '" + applicationId + "'");
            }
            try (Lock lock = this.tenant.getApplicationRepo().lock(applicationId);){
                previousActiveSession = this.applicationRepository.getActiveSession(applicationId);
                waiter = this.applicationRepository.activate(this.session, previousActiveSession, applicationId, this.ignoreSessionStaleFailure);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerException("Error when activating '" + applicationId + "'", e);
            }
            waiter.awaitCompletion(timeoutBudget.timeLeft());
            log.log(Level.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + this.hostProvisioner.map(provisioner -> provisioner.getClass().getSimpleName()).orElse("no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration() + (String)(previousActiveSession != null ? ". Based on session " + previousActiveSession.getSessionId() : "") + ". File references: " + this.applicationRepository.getFileReferences(applicationId));
        }
    }

    public void restart(HostFilter filter) {
        this.hostProvisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public LocalSession session() {
        return this.session;
    }

    private void validateSessionStatus(LocalSession localSession) {
        long sessionId = localSession.getSessionId();
        if (Session.Status.NEW.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is already active");
        }
    }
}

