/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.session.SessionRepository;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.time.Instant;

public class Tenant {
    static final String SESSIONS = "sessions";
    static final String APPLICATIONS = "applications";
    private final TenantName name;
    private final Path path;
    private final SessionRepository sessionRepository;
    private final TenantApplications applicationRepo;
    private final RequestHandler requestHandler;
    private final Instant created;

    protected Tenant(TenantName name, SessionRepository sessionRepository, RequestHandler requestHandler, TenantApplications applicationRepo, Instant created) {
        this.name = name;
        this.path = TenantRepository.getTenantPath(name);
        this.requestHandler = requestHandler;
        this.sessionRepository = sessionRepository;
        this.applicationRepo = applicationRepo;
        this.created = created;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public TenantName getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public SessionRepository getSessionRepository() {
        return this.sessionRepository;
    }

    public String toString() {
        return this.getName().value();
    }

    public TenantApplications getApplicationRepo() {
        return this.applicationRepo;
    }

    public Instant getCreatedTime() {
        return this.created;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Tenant)) {
            return false;
        }
        Tenant that = (Tenant)other;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    void close() {
        this.applicationRepo.close();
        this.sessionRepository.close();
    }
}

