/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PermanentApplicationPackage {
    private static final Logger log = Logger.getLogger(PermanentApplicationPackage.class.getName());
    private final Optional<ApplicationPackage> applicationPackage;

    public PermanentApplicationPackage(ConfigserverConfig config) {
        File app = new File(Defaults.getDefaults().underVespaHome(config.applicationDirectory()));
        this.applicationPackage = Optional.ofNullable(app.exists() ? FilesApplicationPackage.fromFile((File)app) : null);
        if (this.applicationPackage.isPresent()) {
            log.log(Level.FINE, "Detected permanent application package in '" + Defaults.getDefaults().underVespaHome(config.applicationDirectory()) + "'. This might add extra services to config models");
        }
    }

    public Optional<ApplicationPackage> applicationPackage() {
        return this.applicationPackage;
    }
}

