/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.component.Version;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.TenantName;
import com.yahoo.path.Path;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.time.Instant;
import java.util.Optional;

public abstract class Session
implements Comparable<Session> {
    private final long sessionId;
    protected final TenantName tenant;
    protected final SessionZooKeeperClient sessionZooKeeperClient;
    protected final Optional<ApplicationPackage> applicationPackage;

    protected Session(TenantName tenant, long sessionId, SessionZooKeeperClient sessionZooKeeperClient) {
        this(tenant, sessionId, sessionZooKeeperClient, Optional.empty());
    }

    protected Session(TenantName tenant, long sessionId, SessionZooKeeperClient sessionZooKeeperClient, ApplicationPackage applicationPackage) {
        this(tenant, sessionId, sessionZooKeeperClient, Optional.of(applicationPackage));
    }

    private Session(TenantName tenant, long sessionId, SessionZooKeeperClient sessionZooKeeperClient, Optional<ApplicationPackage> applicationPackage) {
        this.tenant = tenant;
        this.sessionId = sessionId;
        this.sessionZooKeeperClient = sessionZooKeeperClient;
        this.applicationPackage = applicationPackage;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    public Status getStatus() {
        return this.sessionZooKeeperClient.readStatus();
    }

    public SessionZooKeeperClient getSessionZooKeeperClient() {
        return this.sessionZooKeeperClient;
    }

    public String toString() {
        return "Session,id=" + this.sessionId;
    }

    public long getActiveSessionAtCreate() {
        return this.getMetaData().getPreviousActiveGeneration();
    }

    public TenantName getTenantName() {
        return this.tenant;
    }

    public String logPre() {
        Optional<Object> applicationId;
        try {
            applicationId = Optional.of(this.getApplicationId());
        }
        catch (Exception e) {
            applicationId = Optional.empty();
        }
        return applicationId.filter(appId -> !appId.equals((Object)ApplicationId.defaultId())).map(TenantRepository::logPre).orElse(TenantRepository.logPre(this.getTenantName()));
    }

    public Instant getCreateTime() {
        return this.sessionZooKeeperClient.readCreateTime();
    }

    public void setApplicationId(ApplicationId applicationId) {
        this.sessionZooKeeperClient.writeApplicationId(applicationId);
    }

    void setApplicationPackageReference(FileReference applicationPackageReference) {
        if (applicationPackageReference == null) {
            throw new IllegalArgumentException(String.format("Null application package file reference for tenant %s, session id %d", this.tenant, this.sessionId));
        }
        this.sessionZooKeeperClient.writeApplicationPackageReference(applicationPackageReference);
    }

    public void setVespaVersion(Version version) {
        this.sessionZooKeeperClient.writeVespaVersion(version);
    }

    public void setDockerImageRepository(Optional<DockerImage> dockerImageRepository) {
        this.sessionZooKeeperClient.writeDockerImageRepository(dockerImageRepository);
    }

    public void setAthenzDomain(Optional<AthenzDomain> athenzDomain) {
        this.sessionZooKeeperClient.writeAthenzDomain(athenzDomain);
    }

    public ApplicationId getApplicationId() {
        return this.sessionZooKeeperClient.readApplicationId().orElseThrow(() -> new RuntimeException("Unable to read application id for session " + this.sessionId));
    }

    public Optional<ApplicationId> getOptionalApplicationId() {
        try {
            return Optional.of(this.getApplicationId());
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public FileReference getApplicationPackageReference() {
        return this.sessionZooKeeperClient.readApplicationPackageReference();
    }

    public Optional<DockerImage> getDockerImageRepository() {
        return this.sessionZooKeeperClient.readDockerImageRepository();
    }

    public Version getVespaVersion() {
        return this.sessionZooKeeperClient.readVespaVersion();
    }

    public Optional<AthenzDomain> getAthenzDomain() {
        return this.sessionZooKeeperClient.readAthenzDomain();
    }

    public AllocatedHosts getAllocatedHosts() {
        return this.sessionZooKeeperClient.getAllocatedHosts();
    }

    public Transaction createDeactivateTransaction() {
        return this.createSetStatusTransaction(Status.DEACTIVATE);
    }

    private Transaction createSetStatusTransaction(Status status) {
        return this.sessionZooKeeperClient.createWriteStatusTransaction(status);
    }

    public boolean isNewerThan(long sessionId) {
        return this.getSessionId() > sessionId;
    }

    public ApplicationMetaData getMetaData() {
        return this.applicationPackage.isPresent() ? this.applicationPackage.get().getMetaData() : this.sessionZooKeeperClient.loadApplicationPackage().getMetaData();
    }

    public ApplicationPackage getApplicationPackage() {
        return this.applicationPackage.orElseThrow(() -> new RuntimeException("No application package found for " + this));
    }

    public ApplicationFile getApplicationFile(Path relativePath, Mode mode) {
        if (mode.equals((Object)Mode.WRITE)) {
            this.markSessionEdited();
        }
        return this.getApplicationPackage().getFile(relativePath);
    }

    private void markSessionEdited() {
        this.setStatus(Status.NEW);
    }

    void setStatus(Status newStatus) {
        this.sessionZooKeeperClient.writeStatus(newStatus);
    }

    @Override
    public int compareTo(Session rhs) {
        Long lhsId = this.getSessionId();
        Long rhsId = rhs.getSessionId();
        return lhsId.compareTo(rhsId);
    }

    public static enum Mode {
        READ,
        WRITE;

    }

    public static enum Status {
        NEW,
        PREPARE,
        ACTIVATE,
        DEACTIVATE,
        DELETE,
        NONE;


        public static Status parse(String data) {
            for (Status status : Status.values()) {
                if (!status.name().equals(data)) continue;
                return status;
            }
            return NEW;
        }
    }
}

