/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.time.Instant;

public class TenantMetaData {
    private final Instant lastDeployTimestamp;

    public TenantMetaData(Instant instant) {
        this.lastDeployTimestamp = instant;
    }

    public Instant lastDeployTimestamp() {
        return this.lastDeployTimestamp;
    }

    public byte[] asJsonBytes() {
        try {
            return SlimeUtils.toJsonBytes((Slime)this.getSlime());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode metadata", e);
        }
    }

    public static TenantMetaData fromJsonString(String jsonString) {
        try {
            Slime data = SlimeUtils.jsonToSlime((String)jsonString);
            Cursor root = data.get();
            Inspector lastDeployTimestamp = root.field("lastDeployTimestamp");
            return new TenantMetaData(Instant.ofEpochMilli(lastDeployTimestamp.asLong()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing json metadata", e);
        }
    }

    private Slime getSlime() {
        Slime slime = new Slime();
        Cursor meta = slime.setObject();
        meta.setLong("lastDeployTimestamp", this.lastDeployTimestamp.toEpochMilli());
        return slime;
    }
}

