/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.log.LogLevel;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.curator.Curator;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class LocalSessionStateWatcher {
    private static final Logger log = Logger.getLogger(LocalSessionStateWatcher.class.getName());
    private static final Executor executor = Executors.newCachedThreadPool(ThreadFactoryFactory.getDaemonThreadFactory((String)LocalSessionStateWatcher.class.getName()));
    private final Curator.FileCache fileCache;
    private final LocalSession session;
    private final LocalSessionRepo localSessionRepo;

    LocalSessionStateWatcher(Curator.FileCache fileCache, LocalSession session, LocalSessionRepo localSessionRepo) {
        this.fileCache = fileCache;
        this.session = session;
        this.localSessionRepo = localSessionRepo;
        this.fileCache.start();
        this.fileCache.addListener(this::nodeChanged);
    }

    private void sessionChanged(Session.Status status) {
        long sessionId = this.session.getSessionId();
        log.log((Level)LogLevel.DEBUG, this.session.logPre() + "Session change: Local session " + sessionId + " changed status to " + status);
        if (status.equals((Object)Session.Status.DELETE) && this.localSessionRepo.getSession(sessionId) != null) {
            log.log((Level)LogLevel.DEBUG, this.session.logPre() + "Deleting session " + sessionId);
            this.localSessionRepo.deleteSession(this.session);
        }
    }

    public long getSessionId() {
        return this.session.getSessionId();
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(LogLevel.WARNING, "Exception when closing watcher", e);
        }
    }

    public void nodeChanged() {
        executor.execute(() -> {
            try {
                ChildData data = this.fileCache.getCurrentData();
                if (data != null) {
                    this.sessionChanged(Session.Status.parse(Utf8.toString((byte[])this.fileCache.getCurrentData().getData())));
                }
            }
            catch (Exception e) {
                log.log(LogLevel.WARNING, this.session.logPre() + "Error handling session changed for session " + this.getSessionId(), e);
            }
        });
    }
}

