/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.zookeeper;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.zookeeper.ZKApplication;
import com.yahoo.vespa.config.util.ConfigUtils;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class ZKApplicationFile
extends ApplicationFile {
    private static final Logger log = Logger.getLogger("ZKApplicationFile");
    private final ZKApplication zkApp;
    private final ObjectMapper mapper = new ObjectMapper();

    public ZKApplicationFile(Path path, ZKApplication app) {
        super(path);
        this.zkApp = app;
    }

    public boolean isDirectory() {
        String data;
        String zkPath = ZKApplicationFile.getZKPath(this.path);
        return this.zkApp.exists(zkPath) && ((data = this.zkApp.getData(zkPath)) == null || data.isEmpty() || !this.zkApp.getChildren(zkPath).isEmpty());
    }

    public boolean exists() {
        try {
            String zkPath = ZKApplicationFile.getZKPath(this.path);
            return this.zkApp.exists(zkPath);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public ApplicationFile delete() {
        if (!this.listFiles().isEmpty()) {
            throw new RuntimeException("Can't delete, directory not empty: " + this);
        }
        this.zkApp.deleteRecurse(ZKApplicationFile.getZKPath(this.path));
        this.writeMetaFile(null, "deleted");
        return this;
    }

    public Reader createReader() throws FileNotFoundException {
        String zkPath = ZKApplicationFile.getZKPath(this.path);
        String data = this.zkApp.getData(zkPath);
        if (data == null) {
            throw new FileNotFoundException("No such path: " + this.path);
        }
        return new StringReader(data);
    }

    public InputStream createInputStream() throws FileNotFoundException {
        String zkPath = ZKApplicationFile.getZKPath(this.path);
        byte[] data = this.zkApp.getBytes(zkPath);
        if (data == null) {
            throw new FileNotFoundException("No such path: " + this.path);
        }
        return new ByteArrayInputStream(data);
    }

    public ApplicationFile createDirectory() {
        String zkPath = ZKApplicationFile.getZKPath(this.path);
        if (this.isDirectory()) {
            return this;
        }
        if (this.exists()) {
            throw new IllegalArgumentException("Unable to create directory, file exists: " + this.path);
        }
        this.zkApp.create(zkPath);
        this.writeMetaFile(null, "new");
        return this;
    }

    public ApplicationFile writeFile(Reader input) {
        String zkPath = ZKApplicationFile.getZKPath(this.path);
        try {
            String data = IOUtils.readAll((Reader)input);
            String status = "new";
            if (this.zkApp.exists(zkPath)) {
                status = "changed";
            }
            this.zkApp.putData(zkPath, data);
            this.writeMetaFile(data, status);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ApplicationFile appendFile(String value) {
        String existingData;
        String zkPath = ZKApplicationFile.getZKPath(this.path);
        String status = "new";
        if (this.zkApp.exists(zkPath)) {
            status = "changed";
        }
        if ((existingData = this.zkApp.getData(zkPath)) == null) {
            existingData = "";
        }
        this.zkApp.putData(zkPath, existingData + value);
        this.writeMetaFile(value, status);
        return this;
    }

    public List<ApplicationFile> listFiles(ApplicationFile.PathFilter filter) {
        String userPath = ZKApplicationFile.getZKPath(this.path);
        ArrayList<ApplicationFile> ret = new ArrayList<ApplicationFile>();
        for (String zkChild : this.zkApp.getChildren(userPath)) {
            Path childPath = this.path.append(zkChild);
            if (childPath.getName().startsWith(".") || !filter.accept(childPath)) continue;
            ret.add(new ZKApplicationFile(childPath, this.zkApp));
        }
        return ret;
    }

    private static String getZKPath(Path path) {
        if (path.isRoot()) {
            return "/userapp";
        }
        return "/userapp/" + path.getRelative();
    }

    private void writeMetaFile(String input, String status) {
        String metaPath = ZKApplicationFile.getZKPath(this.getMetaPath());
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue((Writer)writer, (Object)new ApplicationFile.MetaData(status, input == null ? "" : ConfigUtils.getMd5((String)input)));
            log.log(Level.FINE, "Writing meta file to " + metaPath);
            this.zkApp.putData(metaPath, writer.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing meta file to " + metaPath, e);
        }
    }

    public ApplicationFile.MetaData getMetaData() {
        String metaPath = ZKApplicationFile.getZKPath(this.getMetaPath());
        log.log(Level.FINE, "Getting metadata for " + metaPath);
        if (!this.zkApp.exists(ZKApplicationFile.getZKPath(this.path))) {
            if (this.zkApp.exists(metaPath)) {
                return this.getMetaDataFromZk(metaPath);
            }
            return null;
        }
        if (this.zkApp.exists(metaPath)) {
            return this.getMetaDataFromZk(metaPath);
        }
        return new ApplicationFile.MetaData("new", this.isDirectory() ? "" : ConfigUtils.getMd5((String)this.zkApp.getData(ZKApplicationFile.getZKPath(this.path))));
    }

    private ApplicationFile.MetaData getMetaDataFromZk(String metaPath) {
        try {
            return (ApplicationFile.MetaData)this.mapper.readValue(this.zkApp.getBytes(metaPath), ApplicationFile.MetaData.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int compareTo(ApplicationFile other) {
        if (other == this) {
            return 0;
        }
        return this.getPath().getName().compareTo(other.getPath().getName());
    }
}

