/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class TimeoutBudget {
    private final Clock clock;
    private final Instant startTime;
    private final List<Instant> measurements = new ArrayList<Instant>();
    private final Instant endTime;

    public TimeoutBudget(Clock clock, Duration duration) {
        this.clock = clock;
        this.startTime = clock.instant();
        this.endTime = this.startTime.plus(duration);
    }

    public Duration timeLeft() {
        Instant now = this.clock.instant();
        this.measurements.add(now);
        Duration duration = Duration.between(now, this.endTime);
        return duration.isNegative() ? Duration.ofMillis(0L) : duration;
    }

    public boolean hasTimeLeft() {
        Instant now = this.clock.instant();
        this.measurements.add(now);
        return now.isBefore(this.endTime);
    }

    public String timesUsed() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        Instant prev = this.startTime;
        for (Instant m : this.measurements) {
            buf.append(Duration.between(prev, m).toMillis());
            prev = m;
            buf.append(" ms, ");
        }
        Instant now = this.clock.instant();
        buf.append("total: ");
        buf.append(Duration.between(this.startTime, now).toMillis());
        buf.append(" ms]");
        return buf.toString();
    }
}

