/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.net.HostName;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.JRTConnectionPool;
import com.yahoo.vespa.config.server.ConfigServerSpec;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FileDistributionUtil {
    public static Set<String> getFileReferencesOnDisk(File directory) {
        HashSet<String> fileReferencesOnDisk = new HashSet<String>();
        File[] filesOnDisk = directory.listFiles();
        if (filesOnDisk != null) {
            fileReferencesOnDisk.addAll(Arrays.stream(filesOnDisk).map(File::getName).collect(Collectors.toSet()));
        }
        return fileReferencesOnDisk;
    }

    public static ConnectionPool createConnectionPool(ConfigserverConfig configserverConfig) {
        List configServers = ConfigServerSpec.fromConfig(configserverConfig).stream().filter(spec -> !spec.getHostName().equals(HostName.getLocalhost())).map(spec -> "tcp/" + spec.getHostName() + ":" + spec.getConfigServerPort()).collect(Collectors.toList());
        return configServers.size() > 0 ? new JRTConnectionPool(new ConfigSourceSet(configServers)) : FileDistributionUtil.emptyConnectionPool();
    }

    public static boolean fileReferenceExistsOnDisk(File downloadDirectory, FileReference applicationPackageReference) {
        return FileDistributionUtil.getFileReferencesOnDisk(downloadDirectory).contains(applicationPackageReference.value());
    }

    static ConnectionPool emptyConnectionPool() {
        return new EmptyConnectionPool();
    }

    private static class EmptyConnectionPool
    implements ConnectionPool {
        private Supervisor supervisor;

        private EmptyConnectionPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            EmptyConnectionPool emptyConnectionPool = this;
            synchronized (emptyConnectionPool) {
                if (this.supervisor != null) {
                    this.supervisor.transport().shutdown().join();
                }
            }
        }

        public void setError(Connection connection, int i) {
        }

        public Connection getCurrent() {
            return null;
        }

        public Connection setNewCurrentConnection() {
            return null;
        }

        public int getSize() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Supervisor getSupervisor() {
            EmptyConnectionPool emptyConnectionPool = this;
            synchronized (emptyConnectionPool) {
                if (this.supervisor == null) {
                    this.supervisor = new Supervisor(new Transport());
                }
            }
            return this.supervisor;
        }
    }
}

