/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.tenant.TenantRepository;

public class GetConfigContext {
    private final ApplicationId app;
    private final RequestHandler requestHandler;
    private final Trace trace;

    private GetConfigContext(ApplicationId app, RequestHandler handler, Trace trace) {
        this.app = app;
        this.requestHandler = handler;
        this.trace = trace;
    }

    public TenantName tenant() {
        return this.app.tenant();
    }

    public ApplicationId applicationId() {
        return this.app;
    }

    public Trace trace() {
        return this.trace;
    }

    public RequestHandler requestHandler() {
        return this.requestHandler;
    }

    public static GetConfigContext create(ApplicationId app, RequestHandler handler, Trace trace) {
        return new GetConfigContext(app, handler, trace);
    }

    public static GetConfigContext testContext(ApplicationId app) {
        return new GetConfigContext(app, null, null);
    }

    public String logPre() {
        return TenantRepository.logPre(this.app);
    }
}

