/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.vespa.config.server.session.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SessionCache<SESSIONTYPE extends Session> {
    private final HashMap<Long, SESSIONTYPE> sessions = new HashMap();

    public synchronized void addSession(SESSIONTYPE session) {
        this.sessions.putIfAbsent(((Session)session).getSessionId(), session);
    }

    synchronized void removeSession(long id) {
        if (!this.sessions.containsKey(id)) {
            throw new IllegalArgumentException("No session with id '" + id + "' exists");
        }
        this.sessions.remove(id);
    }

    public synchronized SESSIONTYPE getSession(long id) {
        return (SESSIONTYPE)((Session)this.sessions.get(id));
    }

    public synchronized List<SESSIONTYPE> getSessions() {
        return new ArrayList<SESSIONTYPE>(this.sessions.values());
    }
}

