/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.metrics;

import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.http.v2.MetricsResponse;
import com.yahoo.vespa.config.server.metrics.ClusterInfo;
import com.yahoo.vespa.config.server.metrics.ClusterMetricsRetriever;
import com.yahoo.vespa.config.server.metrics.MetricsAggregator;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApplicationMetricsRetriever {
    private final ClusterMetricsRetriever metricsRetriever;

    public ApplicationMetricsRetriever() {
        this(new ClusterMetricsRetriever());
    }

    public ApplicationMetricsRetriever(ClusterMetricsRetriever metricsRetriever) {
        this.metricsRetriever = metricsRetriever;
    }

    public MetricsResponse getMetrics(Application application) {
        Collection<URI> hosts = ApplicationMetricsRetriever.getHostsOfApplication(application);
        Map<ClusterInfo, MetricsAggregator> clusterMetrics = this.metricsRetriever.requestMetricsGroupedByCluster(hosts);
        return new MetricsResponse(200, application.getId(), clusterMetrics);
    }

    private static Collection<URI> getHostsOfApplication(Application application) {
        return application.getModel().getHosts().stream().filter(host -> host.getServices().stream().noneMatch(ApplicationMetricsRetriever.isLogserver())).map(HostInfo::getHostname).map(ApplicationMetricsRetriever::createMetricsProxyURI).collect(Collectors.toList());
    }

    private static Predicate<ServiceInfo> isLogserver() {
        return serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("logserver");
    }

    private static URI createMetricsProxyURI(String hostname) {
        return URI.create("http://" + hostname + ":19092/metrics/v1/values?consumer=Vespa");
    }
}

