/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.time.Clock;
import java.time.Duration;

public class TenantsMaintainer
extends ConfigServerMaintainer {
    static final Duration defaultTtlForUnusedTenant = Duration.ofDays(7L);
    private final Duration ttlForUnusedTenant = defaultTtlForUnusedTenant;
    private final Clock clock;

    TenantsMaintainer(ApplicationRepository applicationRepository, Curator curator, FlagSource flagSource, Duration interval, Clock clock) {
        super(applicationRepository, curator, flagSource, interval, interval);
        this.clock = clock;
    }

    protected void maintain() {
        this.applicationRepository.deleteUnusedTenants(this.ttlForUnusedTenant, this.clock.instant());
    }
}

