/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.server.http.SessionResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class SessionContentStatusListResponse
extends SessionResponse {
    private static final Logger log = Logger.getLogger("SessionContentStatusListResponse");
    private final Slime slime = new Slime();

    public SessionContentStatusListResponse(String urlBase, List<ApplicationFile> files) {
        Cursor array = this.slime.setArray();
        for (ApplicationFile f : files) {
            Cursor element = array.addObject();
            element.setString("status", f.getMetaData().getStatus());
            element.setString("md5", f.getMetaData().getMd5());
            element.setString("name", urlBase + f.getPath());
            log.log(Level.FINE, "Adding file " + urlBase + f.getPath());
        }
    }

    @Override
    public void render(OutputStream outputStream) throws IOException {
        new JsonFormat(true).encode(outputStream, this.slime);
    }
}

