/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.filedistribution;

import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringArray;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDistributionImpl
implements FileDistribution {
    private static final Logger log = Logger.getLogger(FileDistributionImpl.class.getName());
    private final Supervisor supervisor;
    private final File fileReferencesDir;

    public FileDistributionImpl(ConfigserverConfig configserverConfig, Supervisor supervisor) {
        this.fileReferencesDir = new File(Defaults.getDefaults().underVespaHome(configserverConfig.fileReferencesDir()));
        this.supervisor = supervisor;
    }

    public void startDownload(String hostName, int port, Set<FileReference> fileReferences) {
        this.startDownloadingFileReferences(hostName, port, fileReferences);
    }

    public File getFileReferencesDir() {
        return this.fileReferencesDir;
    }

    private void startDownloadingFileReferences(String hostName, int port, Set<FileReference> fileReferences) {
        Target target = this.supervisor.connect(new Spec(hostName, port));
        double timeout = 0.1;
        Request request = new Request("filedistribution.setFileReferencesToDownload");
        request.parameters().add((Value)new StringArray((String[])fileReferences.stream().map(FileReference::value).toArray(String[]::new)));
        log.log((Level)LogLevel.DEBUG, "Executing " + request.methodName() + " against " + target.toString());
        target.invokeSync(request, timeout);
        if (request.isError() && request.errorCode() != 104) {
            log.log((Level)LogLevel.DEBUG, request.methodName() + " failed: " + request.errorCode() + " (" + request.errorMessage() + ")");
        }
        target.close();
    }
}

