/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.log.LogLevel;
import com.yahoo.slime.Cursor;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeployHandlerLogger
implements DeployLogger {
    private static final Logger log = Logger.getLogger(DeployHandlerLogger.class.getName());
    private final Cursor logroot;
    private final boolean verbose;
    private final ApplicationId app;

    public DeployHandlerLogger(Cursor root, boolean verbose, ApplicationId app) {
        this.logroot = root;
        this.verbose = verbose;
        this.app = app;
    }

    public void log(Level level, String message) {
        if (!(level != Level.FINE && level != LogLevel.DEBUG && level != LogLevel.SPAM || this.verbose)) {
            return;
        }
        String fullMsg = TenantRepository.logPre(this.app) + message;
        Cursor entry = this.logroot.addObject();
        entry.setLong("time", System.currentTimeMillis());
        entry.setString("level", level.getName());
        entry.setString("message", fullMsg);
        log.log(Level.FINE, fullMsg);
    }
}

