/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.ActivationConflictException;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.curator.Lock;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deployment
implements com.yahoo.config.provision.Deployment {
    private static final Logger log = Logger.getLogger(Deployment.class.getName());
    private final LocalSession session;
    private final ApplicationRepository applicationRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Tenant tenant;
    private final Duration timeout;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    Optional<DockerImage> dockerImageRepository;
    private final Version version;
    private final boolean isBootstrap;
    private final Optional<AthenzDomain> athenzDomain;
    private boolean prepared = false;
    private boolean validate;
    private boolean ignoreSessionStaleFailure = false;

    private Deployment(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean prepared, boolean validate, boolean isBootstrap) {
        this.session = session;
        this.applicationRepository = applicationRepository;
        this.hostProvisioner = hostProvisioner;
        this.tenant = tenant;
        this.timeout = timeout;
        this.clock = clock;
        this.prepared = prepared;
        this.validate = validate;
        this.dockerImageRepository = session.getDockerImageRepository();
        this.version = session.getVespaVersion();
        this.isBootstrap = isBootstrap;
        this.athenzDomain = session.getAthenzDomain();
    }

    public static Deployment unprepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean validate, boolean isBootstrap) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, false, validate, isBootstrap);
    }

    public static Deployment prepared(LocalSession session, ApplicationRepository applicationRepository, Optional<Provisioner> hostProvisioner, Tenant tenant, Duration timeout, Clock clock, boolean isBootstrap) {
        return new Deployment(session, applicationRepository, hostProvisioner, tenant, timeout, clock, true, true, isBootstrap);
    }

    public void setIgnoreSessionStaleFailure(boolean ignoreSessionStaleFailure) {
        this.ignoreSessionStaleFailure = ignoreSessionStaleFailure;
    }

    public void prepare() {
        if (this.prepared) {
            return;
        }
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(this.session.getApplicationId(), "deployment.prepareMillis");){
            TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
            PrepareParams.Builder params = new PrepareParams.Builder().applicationId(this.session.getApplicationId()).timeoutBudget(timeoutBudget).ignoreValidationErrors(!this.validate).vespaVersion(this.version.toString()).isBootstrap(this.isBootstrap);
            this.dockerImageRepository.ifPresent(params::dockerImageRepository);
            this.athenzDomain.ifPresent(params::athenzDomain);
            this.session.prepare(this.logger, params.build(), Optional.empty(), this.tenant.getPath(), this.clock.instant());
            this.prepared = true;
        }
    }

    public void activate() {
        if (!this.prepared) {
            this.prepare();
        }
        try (ApplicationRepository.ActionTimer timer = this.applicationRepository.timerFor(this.session.getApplicationId(), "deployment.activateMillis");){
            RemoteSession previousActiveSession;
            TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, this.timeout);
            ApplicationId applicationId = this.session.getApplicationId();
            if (!timeoutBudget.hasTimeLeft()) {
                throw new RuntimeException("Timeout exceeded when trying to activate '" + applicationId + "'");
            }
            try (Lock lock = this.tenant.getApplicationRepo().lock(applicationId);){
                this.validateSessionStatus(this.session);
                NestedTransaction transaction = new NestedTransaction();
                previousActiveSession = this.applicationRepository.getActiveSession(applicationId);
                transaction.add(Deployment.deactivateCurrentActivateNew(previousActiveSession, this.session, this.ignoreSessionStaleFailure), new Class[0]);
                this.hostProvisioner.ifPresent(provisioner -> provisioner.activate(transaction, applicationId, (Collection)this.session.getAllocatedHosts().getHosts()));
                transaction.commit();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalServerException("Error activating application", e);
            }
            this.session.waitUntilActivated(timeoutBudget);
            log.log(Level.INFO, this.session.logPre() + "Session " + this.session.getSessionId() + " activated successfully using " + (this.hostProvisioner.isPresent() ? this.hostProvisioner.get().getClass().getSimpleName() : "no host provisioner") + ". Config generation " + this.session.getMetaData().getGeneration() + (String)(previousActiveSession != null ? ". Activated session based on previous active session " + previousActiveSession.getSessionId() : "") + ". File references used: " + this.applicationRepository.getFileReferences(applicationId));
        }
    }

    public void restart(HostFilter filter) {
        this.hostProvisioner.get().restart(this.session.getApplicationId(), filter);
    }

    public LocalSession session() {
        return this.session;
    }

    private void validateSessionStatus(LocalSession localSession) {
        long sessionId = localSession.getSessionId();
        if (Session.Status.NEW.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is not prepared");
        }
        if (Session.Status.ACTIVATE.equals((Object)localSession.getStatus())) {
            throw new IllegalStateException(localSession.logPre() + "Session " + sessionId + " is already active");
        }
    }

    private static Transaction deactivateCurrentActivateNew(Session active, LocalSession prepared, boolean ignoreStaleSessionFailure) {
        Transaction transaction = prepared.createActivateTransaction();
        if (Deployment.isValidSession(active)) {
            Deployment.checkIfActiveHasChanged(prepared, active, ignoreStaleSessionFailure);
            Deployment.checkIfActiveIsNewerThanSessionToBeActivated(prepared.getSessionId(), active.getSessionId());
            transaction.add(active.createDeactivateTransaction().operations());
        }
        return transaction;
    }

    private static boolean isValidSession(Session session) {
        return session != null;
    }

    private static void checkIfActiveHasChanged(LocalSession session, Session currentActiveSession, boolean ignoreStaleSessionFailure) {
        long activeSessionAtCreate = session.getActiveSessionAtCreate();
        log.log(Level.FINE, currentActiveSession.logPre() + "active session id at create time=" + activeSessionAtCreate);
        if (activeSessionAtCreate == 0L) {
            return;
        }
        long sessionId = session.getSessionId();
        long currentActiveSessionSessionId = currentActiveSession.getSessionId();
        log.log(Level.FINE, currentActiveSession.logPre() + "sessionId=" + sessionId + ", current active session=" + currentActiveSessionSessionId);
        if (currentActiveSession.isNewerThan(activeSessionAtCreate) && currentActiveSessionSessionId != sessionId) {
            String errMsg = currentActiveSession.logPre() + "Cannot activate session " + sessionId + " because the currently active session (" + currentActiveSessionSessionId + ") has changed since session " + sessionId + " was created (was " + activeSessionAtCreate + " at creation time)";
            if (ignoreStaleSessionFailure) {
                log.warning(errMsg + " (Continuing because of force.)");
            } else {
                throw new ActivationConflictException(errMsg);
            }
        }
    }

    private static void checkIfActiveIsNewerThanSessionToBeActivated(long sessionId, long currentActiveSessionId) {
        if (sessionId < currentActiveSessionId) {
            throw new ActivationConflictException("It is not possible to activate session " + sessionId + ", because it is older than current active session (" + currentActiveSessionId + ")");
        }
    }
}

