/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import java.time.Duration;
import java.time.Instant;

public class TenantsMaintainer
extends ConfigServerMaintainer {
    private final Duration ttlForUnusedTenant;

    TenantsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval) {
        this(applicationRepository, curator, interval, Duration.ofDays(7L));
    }

    private TenantsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, Duration ttlForUnusedTenant) {
        super(applicationRepository, curator, interval, interval);
        this.ttlForUnusedTenant = ttlForUnusedTenant;
    }

    protected void maintain() {
        this.applicationRepository.deleteUnusedTenants(this.ttlForUnusedTenant, Instant.now());
    }
}

