/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.transaction.AbstractTransaction;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionPreparer;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Curator;
import java.io.File;
import java.time.Instant;
import java.util.Optional;

public class LocalSession
extends Session
implements Comparable<LocalSession> {
    protected final ApplicationPackage applicationPackage;
    private final TenantApplications applicationRepo;
    private final SessionPreparer sessionPreparer;
    private final File serverDBSessionDir;
    private final SessionZooKeeperClient sessionZooKeeperClient;
    private final HostValidator<ApplicationId> hostValidator;

    public LocalSession(TenantName tenant, long sessionId, SessionPreparer sessionPreparer, ApplicationPackage applicationPackage, SessionZooKeeperClient sessionZooKeeperClient, File serverDBSessionDir, TenantApplications applicationRepo, HostValidator<ApplicationId> hostValidator) {
        super(tenant, sessionId, sessionZooKeeperClient);
        this.serverDBSessionDir = serverDBSessionDir;
        this.applicationPackage = applicationPackage;
        this.sessionZooKeeperClient = sessionZooKeeperClient;
        this.applicationRepo = applicationRepo;
        this.sessionPreparer = sessionPreparer;
        this.hostValidator = hostValidator;
    }

    public ConfigChangeActions prepare(DeployLogger logger, PrepareParams params, Optional<ApplicationSet> currentActiveApplicationSet, Path tenantPath, Instant now) {
        this.applicationRepo.createApplication(params.getApplicationId());
        Curator.CompletionWaiter waiter = this.zooKeeperClient.createPrepareWaiter();
        ConfigChangeActions actions = this.sessionPreparer.prepare(this.hostValidator, logger, params, currentActiveApplicationSet, tenantPath, now, this.serverDBSessionDir, this.applicationPackage, this.sessionZooKeeperClient);
        this.setPrepared();
        waiter.awaitCompletion(params.getTimeoutBudget().timeLeft());
        return actions;
    }

    public ApplicationFile getApplicationFile(Path relativePath, Mode mode) {
        if (mode.equals((Object)Mode.WRITE)) {
            this.markSessionEdited();
        }
        return this.applicationPackage.getFile(relativePath);
    }

    private void setPrepared() {
        this.setStatus(Session.Status.PREPARE);
    }

    private Transaction createSetStatusTransaction(Session.Status status) {
        return this.zooKeeperClient.createWriteStatusTransaction(status);
    }

    private void setStatus(Session.Status newStatus) {
        this.zooKeeperClient.writeStatus(newStatus);
    }

    public Transaction createActivateTransaction() {
        this.zooKeeperClient.createActiveWaiter();
        Transaction transaction = this.createSetStatusTransaction(Session.Status.ACTIVATE);
        transaction.add(this.applicationRepo.createPutTransaction(this.zooKeeperClient.readApplicationId(), this.getSessionId()).operations());
        return transaction;
    }

    private void markSessionEdited() {
        this.setStatus(Session.Status.NEW);
    }

    public long getActiveSessionAtCreate() {
        return this.applicationPackage.getMetaData().getPreviousActiveGeneration();
    }

    public void delete(NestedTransaction transaction) {
        transaction.add((Transaction)this.zooKeeperClient.deleteTransaction(), new Class[]{FileTransaction.class});
        transaction.add((Transaction)FileTransaction.from(FileOperations.delete(this.serverDBSessionDir.getAbsolutePath())), new Class[0]);
    }

    @Override
    public int compareTo(LocalSession rhs) {
        Long lhsId = this.getSessionId();
        Long rhsId = rhs.getSessionId();
        return lhsId.compareTo(rhsId);
    }

    public void waitUntilActivated(TimeoutBudget timeoutBudget) {
        this.zooKeeperClient.getActiveWaiter().awaitCompletion(timeoutBudget.timeLeft());
    }

    public ApplicationMetaData getMetaData() {
        return this.applicationPackage.getMetaData();
    }

    @Override
    public AllocatedHosts getAllocatedHosts() {
        return this.zooKeeperClient.getAllocatedHosts();
    }

    public TenantName getTenantName() {
        return this.tenant;
    }

    @Override
    public String logPre() {
        if (this.getApplicationId().equals((Object)ApplicationId.defaultId())) {
            return TenantRepository.logPre(this.getTenant());
        }
        return TenantRepository.logPre(this.getApplicationId());
    }

    private static class DeleteOperation
    implements FileOperation {
        private final String pathToDelete;

        DeleteOperation(String pathToDelete) {
            this.pathToDelete = pathToDelete;
        }

        @Override
        public void commit() {
            IOUtils.recursiveDeleteDir((File)new File(this.pathToDelete));
        }
    }

    private static interface FileOperation
    extends Transaction.Operation {
        public void commit();
    }

    private static class FileOperations {
        private FileOperations() {
        }

        public static DeleteOperation delete(String pathToDelete) {
            return new DeleteOperation(pathToDelete);
        }
    }

    private static class FileTransaction
    extends AbstractTransaction {
        private FileTransaction() {
        }

        public static FileTransaction from(FileOperation operation) {
            FileTransaction transaction = new FileTransaction();
            transaction.add(operation);
            return transaction;
        }

        public void prepare() {
        }

        public void commit() {
            for (Transaction.Operation operation : this.operations()) {
                ((FileOperation)operation).commit();
            }
        }
    }

    public static enum Mode {
        READ,
        WRITE;

    }
}

