/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.maintenance;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.maintenance.ConfigServerMaintainer;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import com.yahoo.vespa.flags.LongFlag;
import java.time.Duration;

public class SessionsMaintainer
extends ConfigServerMaintainer {
    private final boolean hostedVespa;
    private final LongFlag expiryTimeFlag;

    SessionsMaintainer(ApplicationRepository applicationRepository, Curator curator, Duration interval, FlagSource flagSource) {
        super(applicationRepository, curator, Duration.ZERO, interval);
        this.hostedVespa = applicationRepository.configserverConfig().hostedVespa();
        this.expiryTimeFlag = (LongFlag)Flags.CONFIGSERVER_SESSIONS_EXPIRY_INTERVAL_IN_DAYS.bindTo(flagSource);
    }

    protected void maintain() {
        this.applicationRepository.deleteExpiredLocalSessions();
        if (this.hostedVespa) {
            Duration expiryTime = Duration.ofDays(this.expiryTimeFlag.value());
            int deleted = this.applicationRepository.deleteExpiredRemoteSessions(expiryTime);
            this.log.log(LogLevel.FINE, "Deleted " + deleted + " expired remote sessions, expiry time " + expiryTime);
        }
    }
}

