/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.application.provider.DeployData;
import com.yahoo.config.model.application.provider.FilesApplicationPackage;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.TenantName;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.server.GlobalComponentRegistry;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.deploy.TenantFileSystemDirs;
import com.yahoo.vespa.config.server.host.HostValidator;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionLoader;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionContext;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.session.SessionPreparer;
import com.yahoo.vespa.config.server.session.SessionZooKeeperClient;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.config.server.zookeeper.ConfigCurator;
import com.yahoo.vespa.config.server.zookeeper.SessionCounter;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.flags.FlagSource;
import java.io.File;
import java.time.Clock;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionFactoryImpl
implements SessionFactory,
LocalSessionLoader {
    private static final Logger log = Logger.getLogger(SessionFactoryImpl.class.getName());
    private static final long nonExistingActiveSession = 0L;
    private final SessionPreparer sessionPreparer;
    private final Curator curator;
    private final ConfigCurator configCurator;
    private final SessionCounter sessionCounter;
    private final TenantApplications applicationRepo;
    private final Path sessionsPath;
    private final TenantFileSystemDirs tenantFileSystemDirs;
    private final HostValidator<ApplicationId> hostRegistry;
    private final TenantName tenant;
    private final String serverId;
    private final Optional<NodeFlavors> nodeFlavors;
    private final Clock clock;
    private final FlagSource flagSource;

    public SessionFactoryImpl(GlobalComponentRegistry globalComponentRegistry, TenantApplications applicationRepo, HostValidator<ApplicationId> hostRegistry, TenantName tenant) {
        this.hostRegistry = hostRegistry;
        this.tenant = tenant;
        this.sessionPreparer = globalComponentRegistry.getSessionPreparer();
        this.curator = globalComponentRegistry.getCurator();
        this.configCurator = globalComponentRegistry.getConfigCurator();
        this.sessionCounter = new SessionCounter(globalComponentRegistry.getConfigCurator(), tenant);
        this.sessionsPath = TenantRepository.getSessionsPath(tenant);
        this.applicationRepo = applicationRepo;
        this.tenantFileSystemDirs = new TenantFileSystemDirs(globalComponentRegistry.getConfigServerDB(), tenant);
        this.serverId = globalComponentRegistry.getConfigserverConfig().serverId();
        this.nodeFlavors = globalComponentRegistry.getZone().nodeFlavors();
        this.clock = globalComponentRegistry.getClock();
        this.flagSource = globalComponentRegistry.getFlagSource();
    }

    @Override
    public LocalSession createSession(File applicationFile, ApplicationId applicationId, TimeoutBudget timeoutBudget) {
        return this.create(applicationFile, applicationId, 0L, false, timeoutBudget);
    }

    private void ensureZKPathDoesNotExist(Path sessionPath) {
        if (this.configCurator.exists(sessionPath.getAbsolute())) {
            throw new IllegalArgumentException("Path " + sessionPath.getAbsolute() + " already exists in ZooKeeper");
        }
    }

    private ApplicationPackage createApplication(File userDir, File configApplicationDir, ApplicationId applicationId, long sessionId, long currentlyActiveSessionId, boolean internalRedeploy) {
        long deployTimestamp = System.currentTimeMillis();
        String user = System.getenv("USER");
        if (user == null) {
            user = "unknown";
        }
        DeployData deployData = new DeployData(user, userDir.getAbsolutePath(), applicationId, Long.valueOf(deployTimestamp), internalRedeploy, Long.valueOf(sessionId), currentlyActiveSessionId);
        return FilesApplicationPackage.fromFileWithDeployData((File)configApplicationDir, (DeployData)deployData);
    }

    private LocalSession createSessionFromApplication(ApplicationPackage applicationPackage, long sessionId, SessionZooKeeperClient sessionZKClient, TimeoutBudget timeoutBudget, Clock clock) {
        log.log(Level.FINE, TenantRepository.logPre(this.tenant) + "Creating session " + sessionId + " in ZooKeeper");
        sessionZKClient.createNewSession(clock.instant());
        log.log(Level.FINE, TenantRepository.logPre(this.tenant) + "Creating upload waiter for session " + sessionId);
        Curator.CompletionWaiter waiter = sessionZKClient.getUploadWaiter();
        log.log(Level.FINE, TenantRepository.logPre(this.tenant) + "Done creating upload waiter for session " + sessionId);
        SessionContext context = new SessionContext(applicationPackage, sessionZKClient, this.getSessionAppDir(sessionId), this.applicationRepo, this.hostRegistry, this.flagSource);
        LocalSession session = new LocalSession(this.tenant, sessionId, this.sessionPreparer, context);
        log.log(Level.FINE, TenantRepository.logPre(this.tenant) + "Waiting on upload waiter for session " + sessionId);
        waiter.awaitCompletion(timeoutBudget.timeLeft());
        log.log(Level.FINE, TenantRepository.logPre(this.tenant) + "Done waiting on upload waiter for session " + sessionId);
        return session;
    }

    @Override
    public LocalSession createSessionFromExisting(Session existingSession, DeployLogger logger, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        File existingApp = this.getSessionAppDir(existingSession.getSessionId());
        ApplicationId existingApplicationId = existingSession.getApplicationId();
        long activeSessionId = this.getActiveSessionId(existingApplicationId);
        logger.log(Level.FINE, "Create new session for application id '" + existingApplicationId + "' from existing active session " + activeSessionId);
        LocalSession session = this.create(existingApp, existingApplicationId, activeSessionId, internalRedeploy, timeoutBudget);
        session.setApplicationId(existingApplicationId);
        session.setVespaVersion(existingSession.getVespaVersion());
        session.setDockerImageRepository(existingSession.getDockerImageRepository());
        session.setAthenzDomain(existingSession.getAthenzDomain());
        return session;
    }

    private LocalSession create(File applicationFile, ApplicationId applicationId, long currentlyActiveSessionId, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        long sessionId = this.sessionCounter.nextSessionId();
        Path sessionIdPath = this.sessionsPath.append(String.valueOf(sessionId));
        try {
            this.ensureZKPathDoesNotExist(sessionIdPath);
            SessionZooKeeperClient sessionZooKeeperClient = new SessionZooKeeperClient(this.curator, this.configCurator, sessionIdPath, this.serverId, this.nodeFlavors);
            File userApplicationDir = this.tenantFileSystemDirs.getUserApplicationDir(sessionId);
            IOUtils.copyDirectory((File)applicationFile, (File)userApplicationDir);
            ApplicationPackage applicationPackage = this.createApplication(applicationFile, userApplicationDir, applicationId, sessionId, currentlyActiveSessionId, internalRedeploy);
            applicationPackage.writeMetaData();
            return this.createSessionFromApplication(applicationPackage, sessionId, sessionZooKeeperClient, timeoutBudget, this.clock);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating session " + sessionIdPath, e);
        }
    }

    private File getSessionAppDir(long sessionId) {
        File appDir = this.tenantFileSystemDirs.getUserApplicationDir(sessionId);
        if (!appDir.exists() || !appDir.isDirectory()) {
            throw new IllegalArgumentException("Unable to find correct application directory for session " + sessionId);
        }
        return appDir;
    }

    @Override
    public LocalSession loadSession(long sessionId) {
        File sessionDir = this.getSessionAppDir(sessionId);
        FilesApplicationPackage applicationPackage = FilesApplicationPackage.fromFile((File)sessionDir);
        Path sessionIdPath = this.sessionsPath.append(String.valueOf(sessionId));
        SessionZooKeeperClient sessionZKClient = new SessionZooKeeperClient(this.curator, this.configCurator, sessionIdPath, this.serverId, this.nodeFlavors);
        SessionContext context = new SessionContext((ApplicationPackage)applicationPackage, sessionZKClient, sessionDir, this.applicationRepo, this.hostRegistry, this.flagSource);
        return new LocalSession(this.tenant, sessionId, this.sessionPreparer, context);
    }

    private long getActiveSessionId(ApplicationId applicationId) {
        List<ApplicationId> applicationIds = this.applicationRepo.activeApplications();
        if (applicationIds.contains(applicationId)) {
            return this.applicationRepo.requireActiveSessionOf(applicationId);
        }
        return 0L;
    }
}

