/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.component.Version;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Deployer;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.InfraDeployer;
import com.yahoo.config.provision.Provisioner;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.docproc.jdisc.metric.NullMetric;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.Metric;
import com.yahoo.path.Path;
import com.yahoo.slime.Slime;
import com.yahoo.transaction.NestedTransaction;
import com.yahoo.transaction.Transaction;
import com.yahoo.vespa.config.server.NotFoundException;
import com.yahoo.vespa.config.server.TimeoutBudget;
import com.yahoo.vespa.config.server.application.Application;
import com.yahoo.vespa.config.server.application.ApplicationSet;
import com.yahoo.vespa.config.server.application.CompressedApplicationInputStream;
import com.yahoo.vespa.config.server.application.ConfigConvergenceChecker;
import com.yahoo.vespa.config.server.application.FileDistributionStatus;
import com.yahoo.vespa.config.server.application.HttpProxy;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.configchange.ConfigChangeActions;
import com.yahoo.vespa.config.server.configchange.RefeedActions;
import com.yahoo.vespa.config.server.configchange.RestartActions;
import com.yahoo.vespa.config.server.deploy.DeployHandlerLogger;
import com.yahoo.vespa.config.server.deploy.Deployment;
import com.yahoo.vespa.config.server.deploy.InfraDeployerProvider;
import com.yahoo.vespa.config.server.http.InternalServerException;
import com.yahoo.vespa.config.server.http.LogRetriever;
import com.yahoo.vespa.config.server.http.SimpleHttpFetcher;
import com.yahoo.vespa.config.server.http.TesterClient;
import com.yahoo.vespa.config.server.http.v2.MetricsResponse;
import com.yahoo.vespa.config.server.http.v2.PrepareResult;
import com.yahoo.vespa.config.server.metrics.ApplicationMetricsRetriever;
import com.yahoo.vespa.config.server.provision.HostProvisionerProvider;
import com.yahoo.vespa.config.server.session.LocalSession;
import com.yahoo.vespa.config.server.session.LocalSessionRepo;
import com.yahoo.vespa.config.server.session.PrepareParams;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.RemoteSessionRepo;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.config.server.session.SessionFactory;
import com.yahoo.vespa.config.server.session.SilentDeployLogger;
import com.yahoo.vespa.config.server.tenant.ApplicationRolesStore;
import com.yahoo.vespa.config.server.tenant.ContainerEndpointsCache;
import com.yahoo.vespa.config.server.tenant.EndpointCertificateMetadataStore;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import com.yahoo.vespa.curator.Lock;
import com.yahoo.vespa.orchestrator.Orchestrator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ApplicationRepository
implements Deployer {
    private static final Logger log = Logger.getLogger(ApplicationRepository.class.getName());
    private final TenantRepository tenantRepository;
    private final Optional<Provisioner> hostProvisioner;
    private final Optional<InfraDeployer> infraDeployer;
    private final ConfigConvergenceChecker convergeChecker;
    private final HttpProxy httpProxy;
    private final Clock clock;
    private final DeployLogger logger = new SilentDeployLogger();
    private final ConfigserverConfig configserverConfig;
    private final FileDistributionStatus fileDistributionStatus;
    private final Orchestrator orchestrator;
    private final LogRetriever logRetriever;
    private final TesterClient testerClient;
    private final Metric metric;

    @Inject
    public ApplicationRepository(TenantRepository tenantRepository, HostProvisionerProvider hostProvisionerProvider, InfraDeployerProvider infraDeployerProvider, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Orchestrator orchestrator, TesterClient testerClient, Metric metric) {
        this(tenantRepository, hostProvisionerProvider.getHostProvisioner(), infraDeployerProvider.getInfraDeployer(), configConvergenceChecker, httpProxy, configserverConfig, orchestrator, new LogRetriever(), new FileDistributionStatus(), Clock.systemUTC(), testerClient, metric);
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Orchestrator orchestrator, Clock clock) {
        this(tenantRepository, hostProvisioner, orchestrator, new ConfigserverConfig(new ConfigserverConfig.Builder()), new LogRetriever(), clock, new TesterClient(), (Metric)new NullMetric());
    }

    public ApplicationRepository(TenantRepository tenantRepository, Provisioner hostProvisioner, Orchestrator orchestrator, ConfigserverConfig configserverConfig, LogRetriever logRetriever, Clock clock, TesterClient testerClient, Metric metric) {
        this(tenantRepository, Optional.of(hostProvisioner), Optional.empty(), new ConfigConvergenceChecker(), new HttpProxy(new SimpleHttpFetcher()), configserverConfig, orchestrator, logRetriever, new FileDistributionStatus(), clock, testerClient, metric);
    }

    private ApplicationRepository(TenantRepository tenantRepository, Optional<Provisioner> hostProvisioner, Optional<InfraDeployer> infraDeployer, ConfigConvergenceChecker configConvergenceChecker, HttpProxy httpProxy, ConfigserverConfig configserverConfig, Orchestrator orchestrator, LogRetriever logRetriever, FileDistributionStatus fileDistributionStatus, Clock clock, TesterClient testerClient, Metric metric) {
        this.tenantRepository = tenantRepository;
        this.hostProvisioner = hostProvisioner;
        this.infraDeployer = infraDeployer;
        this.convergeChecker = configConvergenceChecker;
        this.httpProxy = httpProxy;
        this.configserverConfig = configserverConfig;
        this.orchestrator = orchestrator;
        this.logRetriever = logRetriever;
        this.fileDistributionStatus = fileDistributionStatus;
        this.clock = clock;
        this.testerClient = testerClient;
        this.metric = metric;
    }

    public PrepareResult prepare(Tenant tenant, long sessionId, PrepareParams prepareParams, Instant now) {
        this.validateThatLocalSessionIsNotActive(tenant, sessionId);
        LocalSession session = this.getLocalSession(tenant, sessionId);
        ApplicationId applicationId = prepareParams.getApplicationId();
        Optional<ApplicationSet> currentActiveApplicationSet = this.getCurrentActiveApplicationSet(tenant, applicationId);
        Slime deployLog = this.createDeployLog();
        DeployHandlerLogger logger = new DeployHandlerLogger(deployLog.get().setArray("log"), prepareParams.isVerbose(), applicationId);
        try (ActionTimer timer = this.timerFor(applicationId, "deployment.prepareMillis");){
            ConfigChangeActions actions = session.prepare(logger, prepareParams, currentActiveApplicationSet, tenant.getPath(), now);
            ApplicationRepository.logConfigChangeActions(actions, logger);
            log.log(Level.INFO, TenantRepository.logPre(applicationId) + "Session " + sessionId + " prepared successfully. ");
            PrepareResult prepareResult = new PrepareResult(sessionId, actions, deployLog);
            return prepareResult;
        }
    }

    public PrepareResult prepareAndActivate(Tenant tenant, long sessionId, PrepareParams prepareParams, boolean ignoreSessionStaleFailure, Instant now) {
        PrepareResult result = this.prepare(tenant, sessionId, prepareParams, now);
        this.activate(tenant, sessionId, prepareParams.getTimeoutBudget(), ignoreSessionStaleFailure);
        return result;
    }

    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams) {
        return this.deploy(in, prepareParams, false, this.clock.instant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrepareResult deploy(CompressedApplicationInputStream in, PrepareParams prepareParams, boolean ignoreSessionStaleFailure, Instant now) {
        PrepareResult prepareResult;
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            prepareResult = this.deploy(this.decompressApplication(in, tempDir), prepareParams, ignoreSessionStaleFailure, now);
        }
        finally {
            this.cleanupTempDirectory(tempDir);
        }
        return prepareResult;
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams) {
        return this.deploy(applicationPackage, prepareParams, false, Instant.now());
    }

    public PrepareResult deploy(File applicationPackage, PrepareParams prepareParams, boolean ignoreSessionStaleFailure, Instant now) {
        ApplicationId applicationId = prepareParams.getApplicationId();
        long sessionId = this.createSession(applicationId, prepareParams.getTimeoutBudget(), applicationPackage);
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        return this.prepareAndActivate(tenant, sessionId, prepareParams, ignoreSessionStaleFailure, now);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application) {
        return this.deployFromLocalActive(application, false);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, boolean bootstrap) {
        return this.deployFromLocalActive(application, Duration.ofSeconds(this.configserverConfig.zookeeper().barrierTimeout()).plus(Duration.ofSeconds(5L)), bootstrap);
    }

    public Optional<com.yahoo.config.provision.Deployment> deployFromLocalActive(ApplicationId application, Duration timeout, boolean bootstrap) {
        Optional<com.yahoo.config.provision.Deployment> infraDeployment = this.infraDeployer.flatMap(d -> d.getDeployment(application));
        if (infraDeployment.isPresent()) {
            return infraDeployment;
        }
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        LocalSession activeSession = this.getActiveLocalSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        TimeoutBudget timeoutBudget = new TimeoutBudget(this.clock, timeout);
        LocalSession newSession = tenant.getSessionFactory().createSessionFromExisting(activeSession, this.logger, true, timeoutBudget);
        tenant.getLocalSessionRepo().addSession(newSession);
        return Optional.of(Deployment.unprepared(newSession, this, this.hostProvisioner, tenant, timeout, this.clock, false, bootstrap));
    }

    public Optional<Instant> lastDeployTime(ApplicationId application) {
        Tenant tenant = this.tenantRepository.getTenant(application.tenant());
        if (tenant == null) {
            return Optional.empty();
        }
        RemoteSession activeSession = this.getActiveSession(tenant, application);
        if (activeSession == null) {
            return Optional.empty();
        }
        return Optional.of(activeSession.getCreateTime());
    }

    public ApplicationId activate(Tenant tenant, long sessionId, TimeoutBudget timeoutBudget, boolean ignoreSessionStaleFailure) {
        LocalSession localSession = this.getLocalSession(tenant, sessionId);
        Deployment deployment = this.deployFromPreparedSession(localSession, tenant, timeoutBudget.timeLeft());
        deployment.setIgnoreSessionStaleFailure(ignoreSessionStaleFailure);
        deployment.activate();
        return localSession.getApplicationId();
    }

    private Deployment deployFromPreparedSession(LocalSession session, Tenant tenant, Duration timeout) {
        return Deployment.prepared(session, this, this.hostProvisioner, tenant, timeout, this.clock, false);
    }

    boolean delete(ApplicationId applicationId) {
        return this.delete(applicationId, Duration.ofSeconds(60L));
    }

    public boolean delete(ApplicationId applicationId, Duration waitTime) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        if (tenant == null) {
            return false;
        }
        TenantApplications tenantApplications = tenant.getApplicationRepo();
        try (Lock lock = tenantApplications.lock(applicationId);){
            if (!tenantApplications.exists(applicationId)) {
                boolean bl = false;
                return bl;
            }
            Optional<Long> activeSession = tenantApplications.activeSessionOf(applicationId);
            if (activeSession.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            long sessionId = activeSession.get();
            try {
                RemoteSession remoteSession = this.getRemoteSession(tenant, sessionId);
                Transaction deleteTransaction = remoteSession.createDeleteTransaction();
                deleteTransaction.commit();
                log.log(Level.INFO, TenantRepository.logPre(applicationId) + "Waiting for session " + sessionId + " to be deleted");
                if (waitTime.isZero() || !this.localSessionHasBeenDeleted(applicationId, sessionId, waitTime)) {
                    deleteTransaction.rollbackOrLog();
                    throw new InternalServerException(applicationId + " was not deleted (waited " + waitTime + "), session " + sessionId);
                }
                log.log(Level.INFO, TenantRepository.logPre(applicationId) + "Session " + sessionId + " deleted");
            }
            catch (NotFoundException e) {
                log.log(Level.INFO, TenantRepository.logPre(applicationId) + "Active session exists, but has not been deleted properly. Trying to cleanup");
            }
            NestedTransaction transaction = new NestedTransaction();
            transaction.add((Transaction)new ContainerEndpointsCache(tenant.getPath(), tenant.getCurator()).delete(applicationId), new Class[0]);
            transaction.add((Transaction)new ApplicationRolesStore(tenant.getCurator(), tenant.getPath()).delete(applicationId), new Class[0]);
            transaction.add((Transaction)new EndpointCertificateMetadataStore(tenant.getCurator(), tenant.getPath()).delete(applicationId), new Class[0]);
            transaction.add((Transaction)tenantApplications.createDeleteTransaction(applicationId), new Class[0]);
            this.hostProvisioner.ifPresent(provisioner -> provisioner.remove(transaction, applicationId));
            transaction.onCommitted(() -> log.log(Level.INFO, "Deleted " + applicationId));
            transaction.commit();
            boolean bl = true;
            return bl;
        }
    }

    public HttpResponse clusterControllerStatusPage(ApplicationId applicationId, String hostName, String pathSuffix) {
        String relativePath = "clustercontroller-status/" + pathSuffix;
        return this.httpProxy.get(this.getApplication(applicationId), hostName, ContainerServiceType.CLUSTERCONTROLLER_CONTAINER.serviceName, relativePath);
    }

    public Long getApplicationGeneration(ApplicationId applicationId) {
        return this.getApplication(applicationId).getApplicationGeneration();
    }

    public void restart(ApplicationId applicationId, HostFilter hostFilter) {
        this.hostProvisioner.ifPresent(provisioner -> provisioner.restart(applicationId, hostFilter));
    }

    public boolean isSuspended(ApplicationId application) {
        return this.orchestrator.getAllSuspendedApplications().contains(application);
    }

    public HttpResponse filedistributionStatus(ApplicationId applicationId, Duration timeout) {
        return this.fileDistributionStatus.status(this.getApplication(applicationId), timeout);
    }

    public Set<String> deleteUnusedFiledistributionReferences(File fileReferencesPath, Duration keepFileReferences) {
        if (!fileReferencesPath.isDirectory()) {
            throw new RuntimeException(fileReferencesPath + " is not a directory");
        }
        HashSet fileReferencesInUse = new HashSet();
        for (ApplicationId application : this.listApplications()) {
            try {
                Optional<Application> app = this.getOptionalApplication(application);
                if (app.isEmpty()) continue;
                fileReferencesInUse.addAll(app.get().getModel().fileReferences().stream().map(FileReference::value).collect(Collectors.toSet()));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Getting file references in use for '" + application + "' failed", e);
            }
        }
        log.log(Level.FINE, "File references in use : " + fileReferencesInUse);
        HashSet fileReferencesOnDisk = new HashSet();
        File[] filesOnDisk = fileReferencesPath.listFiles();
        if (filesOnDisk != null) {
            fileReferencesOnDisk.addAll(Arrays.stream(filesOnDisk).map(File::getName).collect(Collectors.toSet()));
        }
        log.log(Level.FINE, "File references on disk (in " + fileReferencesPath + "): " + fileReferencesOnDisk);
        Instant instant = Instant.now().minus(keepFileReferences);
        Set<String> fileReferencesToDelete = fileReferencesOnDisk.stream().filter(fileReference -> !fileReferencesInUse.contains(fileReference)).filter(fileReference -> this.isFileLastModifiedBefore(new File(fileReferencesPath, (String)fileReference), instant)).collect(Collectors.toSet());
        if (fileReferencesToDelete.size() > 0) {
            log.log(Level.INFO, "Will delete file references not in use: " + fileReferencesToDelete);
            fileReferencesToDelete.forEach(fileReference -> {
                File file = new File(fileReferencesPath, (String)fileReference);
                if (!IOUtils.recursiveDeleteDir((File)file)) {
                    log.log(Level.WARNING, "Could not delete " + file.getAbsolutePath());
                }
            });
        }
        return fileReferencesToDelete;
    }

    public Set<FileReference> getFileReferences(ApplicationId applicationId) {
        return this.getOptionalApplication(applicationId).map(app -> app.getModel().fileReferences()).orElse(Set.of());
    }

    public ApplicationFile getApplicationFileFromSession(TenantName tenantName, long sessionId, String path, LocalSession.Mode mode) {
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        return this.getLocalSession(tenant, sessionId).getApplicationFile(Path.fromString((String)path), mode);
    }

    private Application getApplication(ApplicationId applicationId) {
        return this.getApplication(applicationId, Optional.empty());
    }

    private Application getApplication(ApplicationId applicationId, Optional<Version> version) {
        try {
            Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
            if (tenant == null) {
                throw new NotFoundException("Tenant '" + applicationId.tenant() + "' not found");
            }
            long sessionId = this.getSessionIdForApplication(tenant, applicationId);
            RemoteSession session = tenant.getRemoteSessionRepo().getSession(sessionId);
            if (session == null) {
                throw new NotFoundException("Remote session " + sessionId + " not found");
            }
            return session.ensureApplicationLoaded().getForVersionOrLatest(version, this.clock.instant());
        }
        catch (NotFoundException e) {
            log.log(Level.WARNING, "Failed getting application for '" + applicationId + "': " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed getting application for '" + applicationId + "'", e);
            throw e;
        }
    }

    private Optional<Application> getOptionalApplication(ApplicationId applicationId) {
        try {
            return Optional.of(this.getApplication(applicationId));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    Set<ApplicationId> listApplications() {
        return this.tenantRepository.getAllTenants().stream().flatMap(tenant -> tenant.getApplicationRepo().activeApplications().stream()).collect(Collectors.toSet());
    }

    private boolean isFileLastModifiedBefore(File fileReference, Instant instant) {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(fileReference.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return fileAttributes.lastModifiedTime().toInstant().isBefore(instant);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean localSessionHasBeenDeleted(ApplicationId applicationId, long sessionId, Duration waitTime) {
        RemoteSessionRepo remoteSessionRepo = this.tenantRepository.getTenant(applicationId.tenant()).getRemoteSessionRepo();
        Instant end = Instant.now().plus(waitTime);
        do {
            if (remoteSessionRepo.getSession(sessionId) == null) {
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Instant.now().isBefore(end));
        return false;
    }

    public HttpResponse checkServiceForConfigConvergence(ApplicationId applicationId, String hostAndPort, URI uri, Duration timeout, Optional<Version> vespaVersion) {
        return this.convergeChecker.checkService(this.getApplication(applicationId, vespaVersion), hostAndPort, uri, timeout);
    }

    public HttpResponse servicesToCheckForConfigConvergence(ApplicationId applicationId, URI uri, Duration timeoutPerService, Optional<Version> vespaVersion) {
        return this.convergeChecker.servicesToCheck(this.getApplication(applicationId, vespaVersion), uri, timeoutPerService);
    }

    public HttpResponse getLogs(ApplicationId applicationId, Optional<String> hostname, String apiParams) {
        String logServerURI = this.getLogServerURI(applicationId, hostname) + apiParams;
        return this.logRetriever.getLogs(logServerURI);
    }

    public HttpResponse getTesterStatus(ApplicationId applicationId) {
        return this.testerClient.getStatus(this.getTesterHostname(applicationId), this.getTesterPort(applicationId));
    }

    public HttpResponse getTesterLog(ApplicationId applicationId, Long after) {
        return this.testerClient.getLog(this.getTesterHostname(applicationId), this.getTesterPort(applicationId), after);
    }

    public HttpResponse startTests(ApplicationId applicationId, String suite, byte[] config) {
        return this.testerClient.startTests(this.getTesterHostname(applicationId), this.getTesterPort(applicationId), suite, config);
    }

    public HttpResponse isTesterReady(ApplicationId applicationId) {
        return this.testerClient.isTesterReady(this.getTesterHostname(applicationId), this.getTesterPort(applicationId));
    }

    private String getTesterHostname(ApplicationId applicationId) {
        return this.getTesterServiceInfo(applicationId).getHostName();
    }

    private int getTesterPort(ApplicationId applicationId) {
        ServiceInfo serviceInfo = this.getTesterServiceInfo(applicationId);
        return serviceInfo.getPorts().stream().filter(portInfo -> portInfo.getTags().contains("http")).findFirst().get().getPort();
    }

    private ServiceInfo getTesterServiceInfo(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        return ((HostInfo)application.getModel().getHosts().stream().findFirst().orElseThrow(() -> new InternalServerException("Could not find any host for tester app " + applicationId.toFullString()))).getServices().stream().filter(service -> ContainerServiceType.CONTAINER.serviceName.equals(service.getServiceType())).findFirst().orElseThrow(() -> new InternalServerException("Could not find any tester container for tester app " + applicationId.toFullString()));
    }

    public RemoteSession getActiveSession(ApplicationId applicationId) {
        return this.getActiveSession(this.tenantRepository.getTenant(applicationId.tenant()), applicationId);
    }

    public long getSessionIdForApplication(ApplicationId applicationId) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        if (tenant == null) {
            throw new NotFoundException("Tenant '" + applicationId.tenant() + "' not found");
        }
        return this.getSessionIdForApplication(tenant, applicationId);
    }

    private long getSessionIdForApplication(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo == null) {
            throw new NotFoundException("Application repo for tenant '" + tenant.getName() + "' not found");
        }
        return applicationRepo.requireActiveSessionOf(applicationId);
    }

    public void validateThatRemoteSessionIsNotActive(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    public void validateThatRemoteSessionIsPrepared(Tenant tenant, long sessionId) {
        RemoteSession session = this.getRemoteSession(tenant, sessionId);
        if (!Session.Status.PREPARE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session not prepared: " + sessionId);
        }
    }

    public long createSessionFromExisting(ApplicationId applicationId, DeployLogger logger, boolean internalRedeploy, TimeoutBudget timeoutBudget) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        LocalSessionRepo localSessionRepo = tenant.getLocalSessionRepo();
        SessionFactory sessionFactory = tenant.getSessionFactory();
        RemoteSession fromSession = this.getExistingSession(tenant, applicationId);
        LocalSession session = sessionFactory.createSessionFromExisting(fromSession, logger, internalRedeploy, timeoutBudget);
        localSessionRepo.addSession(session);
        return session.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, InputStream in, String contentType) {
        long sessionId;
        File tempDir = com.google.common.io.Files.createTempDir();
        try {
            sessionId = this.createSession(applicationId, timeoutBudget, this.decompressApplication(in, contentType, tempDir));
        }
        finally {
            this.cleanupTempDirectory(tempDir);
        }
        return sessionId;
    }

    public long createSession(ApplicationId applicationId, TimeoutBudget timeoutBudget, File applicationDirectory) {
        Tenant tenant = this.tenantRepository.getTenant(applicationId.tenant());
        tenant.getApplicationRepo().createApplication(applicationId);
        LocalSessionRepo localSessionRepo = tenant.getLocalSessionRepo();
        SessionFactory sessionFactory = tenant.getSessionFactory();
        LocalSession session = sessionFactory.createSession(applicationDirectory, applicationId, timeoutBudget);
        localSessionRepo.addSession(session);
        return session.getSessionId();
    }

    public void deleteExpiredLocalSessions() {
        HashMap sessionsPerTenant = new HashMap();
        this.tenantRepository.getAllTenants().forEach(tenant -> sessionsPerTenant.put(tenant, tenant.getLocalSessionRepo().getSessions()));
        HashSet applicationIds = new HashSet();
        sessionsPerTenant.values().forEach(sessionList -> sessionList.forEach(s -> applicationIds.add(s.getApplicationId())));
        HashMap activeSessions = new HashMap();
        applicationIds.forEach(applicationId -> {
            RemoteSession activeSession = this.getActiveSession((ApplicationId)applicationId);
            if (activeSession != null) {
                activeSessions.put(applicationId, activeSession.getSessionId());
            }
        });
        sessionsPerTenant.keySet().forEach(tenant -> tenant.getLocalSessionRepo().deleteExpiredSessions(activeSessions));
    }

    public int deleteExpiredRemoteSessions(Duration expiryTime) {
        return this.deleteExpiredRemoteSessions(this.clock, expiryTime);
    }

    public int deleteExpiredRemoteSessions(Clock clock, Duration expiryTime) {
        return this.tenantRepository.getAllTenants().stream().map(tenant -> tenant.getRemoteSessionRepo().deleteExpiredSessions(clock, expiryTime)).mapToInt(i -> i).sum();
    }

    public TenantRepository tenantRepository() {
        return this.tenantRepository;
    }

    public Set<TenantName> deleteUnusedTenants(Duration ttlForUnusedTenant, Instant now) {
        return this.tenantRepository.getAllTenantNames().stream().filter(tenantName -> this.activeApplications((TenantName)tenantName).isEmpty()).filter(tenantName -> !tenantName.equals((Object)TenantName.defaultName())).filter(tenantName -> !tenantName.equals((Object)TenantRepository.HOSTED_VESPA_TENANT)).filter(tenantName -> this.tenantRepository.getTenant((TenantName)tenantName).getCreatedTime().isBefore(now.minus(ttlForUnusedTenant))).peek(this.tenantRepository::deleteTenant).collect(Collectors.toSet());
    }

    public void deleteTenant(TenantName tenantName) {
        List<ApplicationId> activeApplications = this.activeApplications(tenantName);
        if (!activeApplications.isEmpty()) {
            throw new IllegalArgumentException("Cannot delete tenant '" + tenantName + "', it has active applications: " + activeApplications);
        }
        this.tenantRepository.deleteTenant(tenantName);
    }

    private List<ApplicationId> activeApplications(TenantName tenantName) {
        return this.tenantRepository.getTenant(tenantName).getApplicationRepo().activeApplications();
    }

    public MetricsResponse getMetrics(ApplicationId applicationId) {
        Application application = this.getApplication(applicationId);
        ApplicationMetricsRetriever applicationMetricsRetriever = new ApplicationMetricsRetriever();
        return applicationMetricsRetriever.getMetrics(application);
    }

    public ApplicationMetaData getMetadataFromLocalSession(Tenant tenant, long sessionId) {
        return this.getLocalSession(tenant, sessionId).getMetaData();
    }

    public ConfigserverConfig configserverConfig() {
        return this.configserverConfig;
    }

    private void validateThatLocalSessionIsNotActive(Tenant tenant, long sessionId) {
        LocalSession session = this.getLocalSession(tenant, sessionId);
        if (Session.Status.ACTIVATE.equals((Object)session.getStatus())) {
            throw new IllegalStateException("Session is active: " + sessionId);
        }
    }

    private LocalSession getLocalSession(Tenant tenant, long sessionId) {
        LocalSession session = tenant.getLocalSessionRepo().getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private RemoteSession getRemoteSession(Tenant tenant, long sessionId) {
        RemoteSession session = tenant.getRemoteSessionRepo().getSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Session " + sessionId + " was not found");
        }
        return session;
    }

    private Optional<ApplicationSet> getCurrentActiveApplicationSet(Tenant tenant, ApplicationId appId) {
        Optional<ApplicationSet> currentActiveApplicationSet = Optional.empty();
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        try {
            long currentActiveSessionId = applicationRepo.requireActiveSessionOf(appId);
            RemoteSession currentActiveSession = this.getRemoteSession(tenant, currentActiveSessionId);
            currentActiveApplicationSet = Optional.ofNullable(currentActiveSession.ensureApplicationLoaded());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return currentActiveApplicationSet;
    }

    private File decompressApplication(InputStream in, String contentType, File tempDir) {
        File file;
        block8: {
            CompressedApplicationInputStream application = CompressedApplicationInputStream.createFromCompressedStream(in, contentType);
            try {
                file = this.decompressApplication(application, tempDir);
                if (application == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (application != null) {
                        try {
                            application.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to decompress data in body", e);
                }
            }
            application.close();
        }
        return file;
    }

    private File decompressApplication(CompressedApplicationInputStream in, File tempDir) {
        try {
            return in.decompress(tempDir);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to decompress stream", e);
        }
    }

    private void cleanupTempDirectory(File tempDir) {
        this.logger.log(Level.FINE, "Deleting tmp dir '" + tempDir + "'");
        if (!IOUtils.recursiveDeleteDir((File)tempDir)) {
            this.logger.log(Level.WARNING, "Not able to delete tmp dir '" + tempDir + "'");
        }
    }

    private RemoteSession getExistingSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        return this.getRemoteSession(tenant, applicationRepo.requireActiveSessionOf(applicationId));
    }

    private RemoteSession getActiveSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo.activeApplications().contains(applicationId)) {
            return tenant.getRemoteSessionRepo().getSession(applicationRepo.requireActiveSessionOf(applicationId));
        }
        return null;
    }

    private LocalSession getActiveLocalSession(Tenant tenant, ApplicationId applicationId) {
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        if (applicationRepo.activeApplications().contains(applicationId)) {
            return tenant.getLocalSessionRepo().getSession(applicationRepo.requireActiveSessionOf(applicationId));
        }
        return null;
    }

    private static void logConfigChangeActions(ConfigChangeActions actions, DeployLogger logger) {
        RefeedActions refeedActions;
        RestartActions restartActions = actions.getRestartActions();
        if (!restartActions.isEmpty()) {
            logger.log(Level.WARNING, "Change(s) between active and new application that require restart:\n" + restartActions.format());
        }
        if (!(refeedActions = actions.getRefeedActions()).isEmpty()) {
            boolean allAllowed = refeedActions.getEntries().stream().allMatch(RefeedActions.Entry::allowed);
            logger.log(allAllowed ? Level.INFO : Level.WARNING, "Change(s) between active and new application that may require re-feed:\n" + refeedActions.format());
        }
    }

    private String getLogServerURI(ApplicationId applicationId, Optional<String> hostname) {
        if (hostname.isPresent()) {
            if (TenantRepository.HOSTED_VESPA_TENANT.equals((Object)applicationId.tenant())) {
                return "http://" + hostname.get() + ":8080/logs";
            }
            throw new IllegalArgumentException("Using hostname parameter when getting logs is not supported for application " + applicationId);
        }
        Application application = this.getApplication(applicationId);
        Collection hostInfos = application.getModel().getHosts();
        HostInfo logServerHostInfo = hostInfos.stream().filter(host -> host.getServices().stream().anyMatch(serviceInfo -> serviceInfo.getServiceType().equalsIgnoreCase("logserver"))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find host info for logserver"));
        ServiceInfo serviceInfo = logServerHostInfo.getServices().stream().filter(service -> List.of(ContainerServiceType.LOGSERVER_CONTAINER.serviceName, ContainerServiceType.CONTAINER.serviceName).contains(service.getServiceType())).findFirst().orElseThrow(() -> new IllegalArgumentException("No container running on logserver host"));
        int port = this.servicePort(serviceInfo);
        return "http://" + logServerHostInfo.getHostname() + ":" + port + "/logs";
    }

    private int servicePort(ServiceInfo serviceInfo) {
        return serviceInfo.getPorts().stream().filter(portInfo -> portInfo.getTags().stream().anyMatch(tag -> tag.equalsIgnoreCase("http"))).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find HTTP port")).getPort();
    }

    public Slime createDeployLog() {
        Slime deployLog = new Slime();
        deployLog.setObject();
        return deployLog;
    }

    public Zone zone() {
        return new Zone(SystemName.from((String)this.configserverConfig.system()), Environment.from((String)this.configserverConfig.environment()), RegionName.from((String)this.configserverConfig.region()));
    }

    public ActionTimer timerFor(ApplicationId id, String metricName) {
        return new ActionTimer(this.metric, this.clock, id, this.configserverConfig.environment(), this.configserverConfig.region(), metricName);
    }

    public static class ActionTimer
    implements AutoCloseable {
        private final Metric metric;
        private final Clock clock;
        private final ApplicationId id;
        private final String environment;
        private final String region;
        private final String name;
        private final Instant start;

        private ActionTimer(Metric metric, Clock clock, ApplicationId id, String environment, String region, String name) {
            this.metric = metric;
            this.clock = clock;
            this.id = id;
            this.environment = environment;
            this.region = region;
            this.name = name;
            this.start = clock.instant();
        }

        @Override
        public void close() {
            this.metric.set(this.name, (Number)Duration.between(this.start, this.clock.instant()).toMillis(), this.metric.createContext(Map.of("applicationId", this.id.toFullString(), "tenantName", this.id.tenant().value(), "app", this.id.application().value() + "." + this.id.instance().value(), "zone", this.environment + "." + this.region)));
        }
    }
}

