/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.tenant;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Rotation;
import com.yahoo.path.Path;
import com.yahoo.vespa.curator.Curator;
import com.yahoo.vespa.curator.transaction.CuratorOperation;
import com.yahoo.vespa.curator.transaction.CuratorOperations;
import com.yahoo.vespa.curator.transaction.CuratorTransaction;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Rotations {
    private final Path path;
    private final Curator curator;

    public Rotations(Curator curator, Path tenantPath) {
        this.curator = curator;
        this.path = tenantPath.append("rotationsCache/");
    }

    public Set<Rotation> readRotationsFromZooKeeper(ApplicationId application) {
        try {
            Optional data = this.curator.getData(this.rotationsOf(application));
            if (!data.isPresent() || ((byte[])data.get()).length == 0) {
                return Collections.emptySet();
            }
            Set rotationIds = (Set)new ObjectMapper().readValue((byte[])data.get(), (TypeReference)new TypeReference<Set<String>>(){});
            return rotationIds.stream().map(Rotation::new).collect(Collectors.toSet());
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading rotations of " + application, e);
        }
    }

    public void writeRotationsToZooKeeper(ApplicationId application, Set<Rotation> rotations) {
        if (rotations.isEmpty()) {
            return;
        }
        try {
            Set rotationIds = rotations.stream().map(Rotation::getId).collect(Collectors.toSet());
            byte[] data = new ObjectMapper().writeValueAsBytes(rotationIds);
            this.curator.set(this.rotationsOf(application), data);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write rotations of " + application, e);
        }
    }

    public CuratorTransaction delete(ApplicationId application) {
        if (!this.curator.exists(this.rotationsOf(application))) {
            return CuratorTransaction.empty((Curator)this.curator);
        }
        return CuratorTransaction.from((CuratorOperation)CuratorOperations.delete((String)this.rotationsOf(application).getAbsolute()), (Curator)this.curator);
    }

    private Path rotationsOf(ApplicationId application) {
        return this.path.append(application.serializedForm());
    }
}

