/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.server.application.TenantApplications;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.Utils;
import com.yahoo.vespa.config.server.http.v2.ListApplicationsResponse;
import com.yahoo.vespa.config.server.tenant.Tenant;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Collection;
import java.util.List;

public class ListApplicationsHandler
extends HttpHandler {
    private final TenantRepository tenantRepository;
    private final Zone zone;

    @Inject
    public ListApplicationsHandler(LoggingRequestHandler.Context ctx, TenantRepository tenantRepository, Zone zone) {
        super(ctx);
        this.tenantRepository = tenantRepository;
        this.zone = zone;
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        TenantName tenantName = Utils.getTenantNameFromApplicationsRequest(request);
        final String urlBase = Utils.getUrlBase(request, "/application/v2/tenant/" + tenantName + "/application/");
        List<ApplicationId> applicationIds = this.listApplicationIds(tenantName);
        Collection applicationUrls = Collections2.transform(applicationIds, (Function)new Function<ApplicationId, String>(){

            public String apply(ApplicationId id) {
                return ListApplicationsHandler.createUrlStringFromId(urlBase, id, ListApplicationsHandler.this.zone);
            }
        });
        return new ListApplicationsResponse(200, applicationUrls);
    }

    private List<ApplicationId> listApplicationIds(TenantName tenantName) {
        Utils.checkThatTenantExists(this.tenantRepository, tenantName);
        Tenant tenant = this.tenantRepository.getTenant(tenantName);
        TenantApplications applicationRepo = tenant.getApplicationRepo();
        return applicationRepo.listApplications();
    }

    private static String createUrlStringFromId(String urlBase, ApplicationId id, Zone zone) {
        StringBuilder sb = new StringBuilder();
        sb.append(urlBase).append(id.application().value());
        sb.append("/environment/").append(zone.environment().value());
        sb.append("/region/").append(zone.region().value());
        sb.append("/instance/").append(id.instance().value());
        return sb.toString();
    }
}

