/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.server.RequestHandler;
import com.yahoo.vespa.config.server.http.HttpConfigRequest;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.v2.HttpConfigRequests;
import com.yahoo.vespa.config.server.http.v2.HttpListConfigsHandler;
import com.yahoo.vespa.config.server.http.v2.HttpListConfigsRequest;
import com.yahoo.vespa.config.server.tenant.TenantRepository;
import java.util.Optional;
import java.util.Set;

public class HttpListNamedConfigsHandler
extends HttpHandler {
    private final TenantRepository tenantRepository;
    private final Zone zone;

    @Inject
    public HttpListNamedConfigsHandler(LoggingRequestHandler.Context ctx, TenantRepository tenantRepository, Zone zone) {
        super(ctx);
        this.tenantRepository = tenantRepository;
        this.zone = zone;
    }

    @Override
    public HttpResponse handleGET(HttpRequest req) {
        HttpListConfigsRequest listReq = HttpListConfigsRequest.createFromNamedListRequest(req);
        RequestHandler requestHandler = HttpConfigRequests.getRequestHandler(this.tenantRepository, listReq);
        ApplicationId appId = listReq.getApplicationId();
        HttpConfigRequest.validateRequestKey(listReq.getKey(), requestHandler, appId);
        Set<ConfigKey<?>> configs = requestHandler.listNamedConfigs(appId, Optional.empty(), listReq.getKey(), listReq.isRecursive());
        String urlBase = HttpListConfigsHandler.getUrlBase(req, listReq, appId, this.zone);
        Set<ConfigKey<?>> allConfigs = requestHandler.allConfigsProduced(appId, Optional.empty());
        return new HttpListConfigsHandler.ListConfigsResponse(configs, allConfigs, urlBase, listReq.isRecursive());
    }
}

