/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.http.v2;

import com.google.inject.Inject;
import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.HostFilter;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.io.IOUtils;
import com.yahoo.jdisc.application.BindingMatch;
import com.yahoo.jdisc.application.UriPattern;
import com.yahoo.vespa.config.server.ApplicationRepository;
import com.yahoo.vespa.config.server.http.ContentHandler;
import com.yahoo.vespa.config.server.http.ContentRequest;
import com.yahoo.vespa.config.server.http.HttpErrorResponse;
import com.yahoo.vespa.config.server.http.HttpHandler;
import com.yahoo.vespa.config.server.http.JSONResponse;
import com.yahoo.vespa.config.server.http.NotFoundException;
import com.yahoo.vespa.config.server.http.v2.ApplicationContentRequest;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationHandler
extends HttpHandler {
    private static final List<UriPattern> URI_PATTERNS = Stream.of("http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/content/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/filedistributionstatus", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/restart", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/suspended", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/serviceconverge", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/serviceconverge/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/clustercontroller/*/status/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/metrics", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/logs", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/tester/*/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*/tester/*", "http://*/application/v2/tenant/*/application/*/environment/*/region/*/instance/*", "http://*/application/v2/tenant/*/application/*").map(UriPattern::new).collect(Collectors.toList());
    private final Zone zone;
    private final ApplicationRepository applicationRepository;

    @Inject
    public ApplicationHandler(LoggingRequestHandler.Context ctx, Zone zone, ApplicationRepository applicationRepository) {
        super(ctx);
        this.zone = zone;
        this.applicationRepository = applicationRepository;
    }

    @Override
    public HttpResponse handleDELETE(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        boolean deleted = this.applicationRepository.delete(applicationId, Duration.ofSeconds(60L));
        if (!deleted) {
            return HttpErrorResponse.notFoundError("Unable to delete " + applicationId.toFullString() + ": Not found");
        }
        return new DeleteApplicationResponse(200, applicationId);
    }

    @Override
    public HttpResponse handleGET(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        Duration timeout = HttpHandler.getRequestTimeout(request, Duration.ofSeconds(5L));
        if (ApplicationHandler.isServiceConvergeRequest(request)) {
            String hostAndPort = ApplicationHandler.getHostNameFromRequest(request);
            return this.applicationRepository.checkServiceForConfigConvergence(applicationId, hostAndPort, request.getUri(), timeout, ApplicationHandler.getVespaVersionFromRequest(request));
        }
        if (ApplicationHandler.isClusterControllerStatusRequest(request)) {
            String hostName = ApplicationHandler.getHostNameFromRequest(request);
            String pathSuffix = ApplicationHandler.getPathSuffix(request);
            return this.applicationRepository.clusterControllerStatusPage(applicationId, hostName, pathSuffix);
        }
        if (ApplicationHandler.isContentRequest(request)) {
            long sessionId = this.applicationRepository.getSessionIdForApplication(applicationId);
            String contentPath = ApplicationHandler.getBindingMatch(request).group(7);
            ApplicationFile applicationFile = this.applicationRepository.getApplicationFileFromSession(applicationId.tenant(), sessionId, contentPath, ContentRequest.getApplicationFileMode(request.getMethod()));
            ApplicationContentRequest contentRequest = new ApplicationContentRequest(request, sessionId, applicationId, this.zone, contentPath, applicationFile);
            return new ContentHandler().get(contentRequest);
        }
        if (ApplicationHandler.isServiceConvergeListRequest(request)) {
            return this.applicationRepository.servicesToCheckForConfigConvergence(applicationId, request.getUri(), timeout, ApplicationHandler.getVespaVersionFromRequest(request));
        }
        if (ApplicationHandler.isFiledistributionStatusRequest(request)) {
            return this.applicationRepository.filedistributionStatus(applicationId, timeout);
        }
        if (ApplicationHandler.isLogRequest(request)) {
            Optional<String> hostname = Optional.ofNullable(request.getProperty("hostname"));
            String apiParams = Optional.ofNullable(request.getUri().getQuery()).map(q -> "?" + q).orElse("");
            return this.applicationRepository.getLogs(applicationId, hostname, apiParams);
        }
        if (ApplicationHandler.isMetricsRequest(request)) {
            return this.applicationRepository.getMetrics(applicationId);
        }
        if (ApplicationHandler.isIsSuspendedRequest(request)) {
            return new ApplicationSuspendedResponse(this.applicationRepository.isSuspended(applicationId));
        }
        if (ApplicationHandler.isTesterRequest(request)) {
            String testerCommand;
            switch (testerCommand = ApplicationHandler.getTesterCommandFromRequest(request)) {
                case "status": {
                    return this.applicationRepository.getTesterStatus(applicationId);
                }
                case "log": {
                    Long after = Long.valueOf(request.getProperty("after"));
                    return this.applicationRepository.getTesterLog(applicationId, after);
                }
                case "ready": {
                    return this.applicationRepository.isTesterReady(applicationId);
                }
            }
            throw new IllegalArgumentException("Unknown tester command in request " + request.getUri().toString());
        }
        return new GetApplicationResponse(200, this.applicationRepository.getApplicationGeneration(applicationId));
    }

    @Override
    public HttpResponse handlePOST(HttpRequest request) {
        ApplicationId applicationId = ApplicationHandler.getApplicationIdFromRequest(request);
        if (request.getUri().getPath().endsWith("restart")) {
            return this.restart(request, applicationId);
        }
        if (ApplicationHandler.isTesterStartTestsRequest(request)) {
            byte[] data;
            try {
                data = IOUtils.readBytes((InputStream)request.getData(), (int)1024000);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read data in request " + request);
            }
            return this.applicationRepository.startTests(applicationId, ApplicationHandler.getSuiteFromRequest(request), data);
        }
        throw new NotFoundException("Illegal POST request '" + request.getUri() + "'");
    }

    private HttpResponse restart(HttpRequest request, ApplicationId applicationId) {
        if (ApplicationHandler.getBindingMatch(request).groupCount() != 7) {
            throw new NotFoundException("Illegal POST restart request '" + request.getUri() + "': Must have 6 arguments but had " + (ApplicationHandler.getBindingMatch(request).groupCount() - 1));
        }
        this.applicationRepository.restart(applicationId, this.hostFilterFrom(request));
        return new JSONResponse(200);
    }

    private HostFilter hostFilterFrom(HttpRequest request) {
        return HostFilter.from((String)request.getProperty("hostname"), (String)request.getProperty("flavor"), (String)request.getProperty("clusterType"), (String)request.getProperty("clusterId"));
    }

    private static BindingMatch<?> getBindingMatch(HttpRequest request) {
        return URI_PATTERNS.stream().map(pattern -> {
            UriPattern.Match match = pattern.match(request.getUri());
            if (match == null) {
                return null;
            }
            return new BindingMatch(match, new Object(), pattern);
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException("Illegal url for config request: " + request.getUri()));
    }

    private static boolean isIsSuspendedRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/suspended");
    }

    private static boolean isMetricsRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/metrics");
    }

    private static boolean isLogRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/logs");
    }

    private static boolean isServiceConvergeListRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().endsWith("/serviceconverge");
    }

    private static boolean isServiceConvergeRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().contains("/serviceconverge/");
    }

    private static boolean isClusterControllerStatusRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 9 && request.getUri().getPath().contains("/clustercontroller/");
    }

    private static boolean isContentRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() > 7 && request.getUri().getPath().contains("/content/");
    }

    private static boolean isFiledistributionStatusRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 7 && request.getUri().getPath().contains("/filedistributionstatus");
    }

    private static boolean isTesterRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 8 && request.getUri().getPath().contains("/tester");
    }

    private static boolean isTesterStartTestsRequest(HttpRequest request) {
        return ApplicationHandler.getBindingMatch(request).groupCount() == 9 && request.getUri().getPath().contains("/tester/run/");
    }

    private static String getHostNameFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(7);
    }

    private static String getTesterCommandFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(7);
    }

    private static String getSuiteFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(8);
    }

    private static String getPathSuffix(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        return bm.group(8);
    }

    private static ApplicationId getApplicationIdFromRequest(HttpRequest req) {
        BindingMatch<?> bm = ApplicationHandler.getBindingMatch(req);
        if (bm.groupCount() > 4) {
            return ApplicationHandler.createFromRequestFullAppId(bm);
        }
        return ApplicationHandler.createFromRequestSimpleAppId(bm);
    }

    private static ApplicationId createFromRequestSimpleAppId(BindingMatch<?> bm) {
        TenantName tenant = TenantName.from((String)bm.group(2));
        ApplicationName application = ApplicationName.from((String)bm.group(3));
        return new ApplicationId.Builder().tenant(tenant).applicationName(application).build();
    }

    private static ApplicationId createFromRequestFullAppId(BindingMatch<?> bm) {
        String tenant = bm.group(2);
        String application = bm.group(3);
        String instance = bm.group(6);
        return new ApplicationId.Builder().tenant(tenant).applicationName(application).instanceName(instance).build();
    }

    private static Optional<Version> getVespaVersionFromRequest(HttpRequest request) {
        String vespaVersion = request.getProperty("vespaVersion");
        return vespaVersion == null || vespaVersion.isEmpty() ? Optional.empty() : Optional.of(Version.fromString((String)vespaVersion));
    }

    private static class ApplicationSuspendedResponse
    extends JSONResponse {
        ApplicationSuspendedResponse(boolean suspended) {
            super(200);
            this.object.setBool("suspended", suspended);
        }
    }

    private static class GetApplicationResponse
    extends JSONResponse {
        GetApplicationResponse(int status, long generation) {
            super(status);
            this.object.setLong("generation", generation);
        }
    }

    private static class DeleteApplicationResponse
    extends JSONResponse {
        DeleteApplicationResponse(int status, ApplicationId applicationId) {
            super(status);
            this.object.setString("message", "Application '" + applicationId + "' deleted");
        }
    }
}

