/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.deploy;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.TlsSecrets;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import com.yahoo.vespa.flags.BooleanFlag;
import com.yahoo.vespa.flags.DoubleFlag;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagSource;
import com.yahoo.vespa.flags.Flags;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ModelContextImpl
implements ModelContext {
    private final ApplicationPackage applicationPackage;
    private final Optional<Model> previousModel;
    private final Optional<ApplicationPackage> permanentApplicationPackage;
    private final DeployLogger deployLogger;
    private final ConfigDefinitionRepo configDefinitionRepo;
    private final FileRegistry fileRegistry;
    private final Optional<HostProvisioner> hostProvisioner;
    private final Provisioned provisioned;
    private final ModelContext.Properties properties;
    private final Optional<File> appDir;
    private final Optional<DockerImage> wantedDockerImageRepository;
    private final Version modelVespaVersion;
    private final Version wantedNodeVespaVersion;

    public ModelContextImpl(ApplicationPackage applicationPackage, Optional<Model> previousModel, Optional<ApplicationPackage> permanentApplicationPackage, DeployLogger deployLogger, ConfigDefinitionRepo configDefinitionRepo, FileRegistry fileRegistry, Optional<HostProvisioner> hostProvisioner, Provisioned provisioned, ModelContext.Properties properties, Optional<File> appDir, Optional<DockerImage> wantedDockerImageRepository, Version modelVespaVersion, Version wantedNodeVespaVersion) {
        this.applicationPackage = applicationPackage;
        this.previousModel = previousModel;
        this.permanentApplicationPackage = permanentApplicationPackage;
        this.deployLogger = deployLogger;
        this.configDefinitionRepo = configDefinitionRepo;
        this.fileRegistry = fileRegistry;
        this.hostProvisioner = hostProvisioner;
        this.provisioned = provisioned;
        this.properties = properties;
        this.appDir = appDir;
        this.wantedDockerImageRepository = wantedDockerImageRepository;
        this.modelVespaVersion = modelVespaVersion;
        this.wantedNodeVespaVersion = wantedNodeVespaVersion;
    }

    public ApplicationPackage applicationPackage() {
        return this.applicationPackage;
    }

    public Optional<Model> previousModel() {
        return this.previousModel;
    }

    public Optional<ApplicationPackage> permanentApplicationPackage() {
        return this.permanentApplicationPackage;
    }

    public Optional<HostProvisioner> hostProvisioner() {
        return this.hostProvisioner;
    }

    public Provisioned provisioned() {
        return this.provisioned;
    }

    public DeployLogger deployLogger() {
        return this.deployLogger;
    }

    public ConfigDefinitionRepo configDefinitionRepo() {
        return this.configDefinitionRepo;
    }

    public FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public ModelContext.Properties properties() {
        return this.properties;
    }

    public Optional<File> appDir() {
        return this.appDir;
    }

    public Optional<String> wantedDockerImageRepository() {
        return this.wantedDockerImageRepository.map(DockerImage::repository);
    }

    public Optional<DockerImage> wantedDockerImageRepo() {
        return this.wantedDockerImageRepository;
    }

    public Version modelVespaVersion() {
        return this.modelVespaVersion;
    }

    public Version wantedNodeVespaVersion() {
        return this.wantedNodeVespaVersion;
    }

    public static class Properties
    implements ModelContext.Properties {
        private final ApplicationId applicationId;
        private final boolean multitenant;
        private final List<ConfigServerSpec> configServerSpecs;
        private final HostName loadBalancerName;
        private final URI ztsUrl;
        private final String athenzDnsSuffix;
        private final boolean hostedVespa;
        private final Zone zone;
        private final Set<ContainerEndpoint> endpoints;
        private final boolean isBootstrap;
        private final boolean isFirstTimeDeployment;
        private final boolean useAdaptiveDispatch;
        private final double defaultTopKprobability;
        private final Optional<EndpointCertificateSecrets> endpointCertificateSecrets;
        private final double defaultTermwiseLimit;
        private final double defaultSoftStartSeconds;
        private final double threadPoolSizeFactor;
        private final double queueSizefactor;
        private final Optional<AthenzDomain> athenzDomain;

        public Properties(ApplicationId applicationId, boolean multitenantFromConfig, List<ConfigServerSpec> configServerSpecs, HostName loadBalancerName, URI ztsUrl, String athenzDnsSuffix, boolean hostedVespa, Zone zone, Set<ContainerEndpoint> endpoints, boolean isBootstrap, boolean isFirstTimeDeployment, FlagSource flagSource, Optional<EndpointCertificateSecrets> endpointCertificateSecrets, Optional<AthenzDomain> athenzDomain) {
            this.applicationId = applicationId;
            this.multitenant = multitenantFromConfig || hostedVespa || Boolean.getBoolean("multitenant");
            this.configServerSpecs = configServerSpecs;
            this.loadBalancerName = loadBalancerName;
            this.ztsUrl = ztsUrl;
            this.athenzDnsSuffix = athenzDnsSuffix;
            this.hostedVespa = hostedVespa;
            this.zone = zone;
            this.endpoints = endpoints;
            this.isBootstrap = isBootstrap;
            this.isFirstTimeDeployment = isFirstTimeDeployment;
            this.useAdaptiveDispatch = ((BooleanFlag)((BooleanFlag)Flags.USE_ADAPTIVE_DISPATCH.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.endpointCertificateSecrets = endpointCertificateSecrets;
            this.defaultTermwiseLimit = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_TERM_WISE_LIMIT.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.defaultSoftStartSeconds = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_SOFT_START_SECONDS.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.defaultTopKprobability = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_TOP_K_PROBABILITY.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.threadPoolSizeFactor = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_THREADPOOL_SIZE_FACTOR.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.queueSizefactor = ((DoubleFlag)((DoubleFlag)Flags.DEFAULT_QUEUE_SIZE_FACTOR.bindTo(flagSource)).with(FetchVector.Dimension.APPLICATION_ID, applicationId.serializedForm())).value();
            this.athenzDomain = athenzDomain;
        }

        public boolean multitenant() {
            return this.multitenant;
        }

        public ApplicationId applicationId() {
            return this.applicationId;
        }

        public List<ConfigServerSpec> configServerSpecs() {
            return this.configServerSpecs;
        }

        public HostName loadBalancerName() {
            return this.loadBalancerName;
        }

        public URI ztsUrl() {
            return this.ztsUrl;
        }

        public String athenzDnsSuffix() {
            return this.athenzDnsSuffix;
        }

        public boolean hostedVespa() {
            return this.hostedVespa;
        }

        public Zone zone() {
            return this.zone;
        }

        public Set<ContainerEndpoint> endpoints() {
            return this.endpoints;
        }

        public boolean isBootstrap() {
            return this.isBootstrap;
        }

        public boolean isFirstTimeDeployment() {
            return this.isFirstTimeDeployment;
        }

        public boolean useAdaptiveDispatch() {
            return this.useAdaptiveDispatch;
        }

        public Optional<TlsSecrets> tlsSecrets() {
            return this.endpointCertificateSecrets.map(TlsSecrets::new);
        }

        public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return this.endpointCertificateSecrets;
        }

        public double defaultTermwiseLimit() {
            return this.defaultTermwiseLimit;
        }

        public double threadPoolSizeFactor() {
            return this.threadPoolSizeFactor;
        }

        public double queueSizeFactor() {
            return this.queueSizefactor;
        }

        public double defaultSoftStartSeconds() {
            return this.defaultSoftStartSeconds;
        }

        public double defaultTopKProbability() {
            return this.defaultTopKprobability;
        }

        public boolean useBucketSpaceMetric() {
            return true;
        }

        public boolean useNewAthenzFilter() {
            return true;
        }

        public Optional<AthenzDomain> athenzDomain() {
            return this.athenzDomain;
        }
    }
}

