/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.session;

import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.server.ReloadHandler;
import com.yahoo.vespa.config.server.monitoring.MetricUpdater;
import com.yahoo.vespa.config.server.session.RemoteSession;
import com.yahoo.vespa.config.server.session.Session;
import com.yahoo.vespa.curator.Curator;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.framework.recipes.cache.ChildData;

public class RemoteSessionStateWatcher {
    private static final Logger log = Logger.getLogger(RemoteSessionStateWatcher.class.getName());
    private final Curator.FileCache fileCache;
    private final ReloadHandler reloadHandler;
    private final RemoteSession session;
    private final MetricUpdater metrics;
    private final Executor zkWatcherExecutor;

    RemoteSessionStateWatcher(Curator.FileCache fileCache, ReloadHandler reloadHandler, RemoteSession session, MetricUpdater metrics, Executor zkWatcherExecutor) {
        this.fileCache = fileCache;
        this.reloadHandler = reloadHandler;
        this.session = session;
        this.metrics = metrics;
        this.fileCache.start();
        this.fileCache.addListener(this::nodeChanged);
        this.zkWatcherExecutor = zkWatcherExecutor;
    }

    private void sessionChanged(Session.Status status) {
        log.log(Level.FINE, this.session.logPre() + "Session change: Remote session " + this.session.getSessionId() + " changed status to " + status);
        if (status.equals((Object)Session.Status.PREPARE)) {
            log.log(Level.FINE, this.session.logPre() + "Loading prepared session: " + this.session.getSessionId());
            this.session.loadPrepared();
        } else if (status.equals((Object)Session.Status.ACTIVATE)) {
            this.session.makeActive(this.reloadHandler);
        } else if (status.equals((Object)Session.Status.DEACTIVATE)) {
            this.session.deactivate();
        } else if (status.equals((Object)Session.Status.DELETE)) {
            this.session.deactivate();
        }
    }

    public long getSessionId() {
        return this.session.getSessionId();
    }

    public void close() {
        try {
            this.fileCache.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception when closing watcher", e);
        }
    }

    private void nodeChanged() {
        this.zkWatcherExecutor.execute(() -> {
            try {
                ChildData node = this.fileCache.getCurrentData();
                if (node != null) {
                    this.sessionChanged(Session.Status.parse(Utf8.toString((byte[])node.getData())));
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, this.session.logPre() + "Error handling session changed for session " + this.getSessionId(), e);
                this.metrics.incSessionChangeErrors();
            }
        });
    }
}

