/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.server.application;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.yahoo.vespa.config.server.http.BadRequestException;
import com.yahoo.vespa.config.server.http.InternalServerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;

public class CompressedApplicationInputStream
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(CompressedApplicationInputStream.class.getPackage().getName());
    private final ArchiveInputStream ais;

    public static CompressedApplicationInputStream createFromCompressedStream(InputStream is, String contentType) {
        try {
            ArchiveInputStream ais = CompressedApplicationInputStream.getArchiveInputStream(is, contentType);
            return CompressedApplicationInputStream.createFromCompressedStream(ais);
        }
        catch (IOException e) {
            throw new InternalServerException("Unable to create compressed application stream", e);
        }
    }

    static CompressedApplicationInputStream createFromCompressedStream(ArchiveInputStream ais) {
        return new CompressedApplicationInputStream(ais);
    }

    private static ArchiveInputStream getArchiveInputStream(InputStream is, String contentTypeHeader) throws IOException {
        ZipArchiveInputStream ais;
        switch (contentTypeHeader) {
            case "application/x-gzip": {
                ais = new TarArchiveInputStream((InputStream)new GZIPInputStream(is));
                break;
            }
            case "application/zip": {
                ais = new ZipArchiveInputStream(is);
                break;
            }
            default: {
                throw new BadRequestException("Unable to decompress");
            }
        }
        return ais;
    }

    private CompressedApplicationInputStream(ArchiveInputStream ais) {
        this.ais = ais;
    }

    @Override
    public void close() throws IOException {
        this.ais.close();
    }

    File decompress() throws IOException {
        return this.decompress(Files.createTempDir());
    }

    public File decompress(File dir) throws IOException {
        this.decompressInto(dir);
        dir = this.findActualApplicationDir(dir);
        return dir;
    }

    private void decompressInto(File application) throws IOException {
        ArchiveEntry entry;
        log.log(Level.FINE, "Application is in " + application.getAbsolutePath());
        int entries = 0;
        while ((entry = this.ais.getNextEntry()) != null) {
            log.log(Level.FINE, "Unpacking " + entry.getName());
            File outFile = new File(application, entry.getName());
            if (entry.isDirectory()) {
                if (!outFile.exists() || !outFile.isDirectory()) {
                    log.log(Level.FINE, "Creating dir: " + outFile.getAbsolutePath());
                    boolean res = outFile.mkdirs();
                    if (!res) {
                        log.log(Level.WARNING, "Could not create dir " + entry.getName());
                    }
                }
            } else {
                log.log(Level.FINE, "Creating output file: " + outFile.getAbsolutePath());
                String parent = outFile.getParent();
                new File(parent).mkdirs();
                FileOutputStream fos = new FileOutputStream(outFile);
                ByteStreams.copy((InputStream)this.ais, (OutputStream)fos);
                fos.close();
            }
            ++entries;
        }
        if (entries == 0) {
            log.log(Level.WARNING, "Not able to read any entries from " + application.getName());
        }
    }

    private File findActualApplicationDir(File application) {
        File[] files = application.listFiles();
        if (files != null && files.length == 1 && files[0].isDirectory()) {
            application = files[0];
        }
        return application;
    }
}

